/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.ETableModelColumn;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedTableCellRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.function.FailableConsumer;

public class ETable<T>
extends JTable {
    private static final long serialVersionUID = 1L;
    private ETableModel<T> model;
    private JPopupMenu popup = new JPopupMenu();
    private List<FailableConsumer<T, Exception>> action_select = new ArrayList<FailableConsumer<T, Exception>>();
    private List<FailableConsumer<T, Exception>> action_doubleclick = new ArrayList<FailableConsumer<T, Exception>>();
    private DateTimeFormatter fmt_date = I18N.getDateFormat();
    private DateTimeFormatter fmt_datetime = I18N.getDateTimeFormat();
    private DecimalFormat fmt_bigdecimal = I18N.getDecimalFormat();

    public ETable() {
        this(new ETableModel());
    }

    public ETable(List<T> data) {
        this(new ETableModel<T>(data));
    }

    public ETable(ETableModel<T> model) {
        this.setModel(model);
        this.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", true);
        this.setDefaultRenderer(LocalDate.class, new FormattedTableCellRenderer(value -> value == null ? "-" : this.fmt_date.format((LocalDate)value)));
        this.setDefaultRenderer(LocalDateTime.class, new FormattedTableCellRenderer(value -> value == null ? "-" : this.fmt_datetime.format((LocalDateTime)value)));
        this.setDefaultRenderer(BigDecimal.class, new FormattedTableCellRenderer(4, value -> value == null ? "-" : this.fmt_bigdecimal.format((BigDecimal)value)));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object selected;
                if (e.getButton() == 1 && (selected = ETable.this.getSelectedObject()) != null && e.getClickCount() == 2) {
                    for (FailableConsumer next : ETable.this.action_doubleclick) {
                        EUtils.catchWithDialog(ETable.this, () -> next.accept(selected));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseEvent(e);
            }

            private void mouseEvent(MouseEvent e) {
                int r = ETable.this.rowAtPoint(e.getPoint());
                if (r >= 0 && r < ETable.this.getRowCount()) {
                    ETable.this.setRowSelectionInterval(r, r);
                }
                if (e.isPopupTrigger() && ETable.this.popup.getSubElements().length != 0) {
                    ETable.this.popup.show(ETable.this, e.getX(), e.getY());
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.fireSelect();
        });
    }

    private void fireSelect() {
        Object selected = this.getSelectedObject();
        for (FailableConsumer next : this.action_select) {
            EUtils.catchWithDialog(this, () -> next.accept(selected));
        }
    }

    @Override
    public ETableModel<T> getModel() {
        return this.model;
    }

    public void setModel(ETableModel<T> model) {
        this.model = model;
        super.setModel(model);
        this.fireSelect();
    }

    @Override
    public void setModel(TableModel dataModel) {
        this.model = null;
        super.setModel(dataModel);
    }

    public List<T> getData() {
        return this.model.getData();
    }

    public void setData(List<T> data) {
        this.model.setData(data);
        this.fireSelect();
    }

    public boolean isEditable() {
        return this.model.isEditable();
    }

    public void setEditable(boolean editable) {
        this.model.setEditable(editable);
        this.fireSelect();
    }

    public T getSelectedObject() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.model.getData().get(row);
    }

    public void setDateFormat(DateTimeFormatter fmt) {
        this.fmt_date = fmt;
    }

    public void setDateTimeFormat(DateTimeFormatter fmt) {
        this.fmt_datetime = fmt;
    }

    public void setBigDecimalFormat(DecimalFormat fmt) {
        this.fmt_bigdecimal = fmt;
    }

    public void resetColumns() {
        this.model.resetColumns();
    }

    public void addColumn(ETableModelColumn<T> col) {
        this.model.addColumn(col);
    }

    public void addColumn(String title, Function<T, Object> getValue) {
        this.model.addColumn(title, getValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue) {
        this.model.addColumn(title, cls, getValue);
    }

    public void addColumn(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.model.addColumn(title, getValue, setValue);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.model.addColumn(title, cls, getValue, setValue);
    }

    public void addColumn(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue, Predicate<T> isEditable) {
        this.model.addColumn(title, getValue, setValue, isEditable);
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, BiConsumer<T, Object> setValue, Predicate<T> isEditable) {
        this.model.addColumn(title, cls, getValue, setValue, isEditable);
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.popup.add(item);
    }

    public void addPopupMenuItem(String text, FailableConsumer<T, Exception> action) {
        JMenuItem item = new JMenuItem(text);
        this.connect(item, action);
        this.addPopupMenuItem(item);
    }

    public void addPopupMenuItem(String text, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        JMenuItem item = new JMenuItem(text);
        this.connect(item, cond, action);
        this.addPopupMenuItem(item);
    }

    public void addSelectAction(FailableConsumer<T, Exception> action) {
        this.action_select.add(action);
    }

    public void addDoubleClickAction(FailableConsumer<T, Exception> action) {
        this.action_doubleclick.add(action);
    }

    public void connect(AbstractButton btn, FailableConsumer<T, Exception> action) {
        btn.addActionListener(e -> EUtils.catchWithDialog(this, () -> action.accept(this.getSelectedObject())));
    }

    public void connect(AbstractButton btn, Predicate<T> cond, FailableConsumer<T, Exception> action) {
        this.addSelectAction(obj -> btn.setEnabled(cond.test(obj)));
        btn.setEnabled(cond.test(this.getSelectedObject()));
        this.connect(btn, action);
    }
}

