/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.gui.ETableModelColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.table.AbstractTableModel;

public class ETableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<T> data;
    private List<ETableModelColumn<T>> columns;
    private boolean editable;

    public ETableModel() {
        this(List.of());
    }

    public ETableModel(List<T> data) {
        this.data = new ArrayList<T>(data);
        this.columns = new ArrayList<ETableModelColumn<T>>();
        this.editable = true;
    }

    public void resetColumns() {
        this.columns.clear();
        this.fireTableStructureChanged();
    }

    public void addColumn(ETableModelColumn<T> col) {
        this.columns.add(col);
        this.fireTableStructureChanged();
    }

    public void addColumn(String title, Function<T, Object> getValue) {
        this.addColumn(ETableModelColumn.create(title, getValue));
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue) {
        this.addColumn(ETableModelColumn.create(title, cls, getValue));
    }

    public void addColumn(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.addColumn(ETableModelColumn.create(title, getValue, setValue));
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        this.addColumn(ETableModelColumn.create(title, cls, getValue, setValue));
    }

    public void addColumn(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue, Predicate<T> isEditable) {
        this.addColumn(ETableModelColumn.create(title, getValue, setValue, isEditable));
    }

    public void addColumn(String title, Class<?> cls, Function<T, Object> getValue, BiConsumer<T, Object> setValue, Predicate<T> isEditable) {
        this.addColumn(ETableModelColumn.create(title, cls, getValue, setValue, isEditable));
    }

    public void setData(List<T> data) {
        this.data = new ArrayList<T>(data);
        this.fireTableDataChanged();
    }

    public List<T> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public void resetRows() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void addRow(T obj) {
        this.data.add(obj);
        this.fireTableDataChanged();
    }

    public void addRow(int idx, T obj) {
        this.data.add(idx, obj);
        this.fireTableDataChanged();
    }

    public T getRow(int idx) {
        return this.data.get(idx);
    }

    public void deleteRow(int idx) {
        this.data.remove(idx);
        this.fireTableDataChanged();
    }

    public void replaceRow(int idx, T obj) {
        this.data.set(idx, obj);
        this.fireTableDataChanged();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getTitle();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getValueClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).getValue(this.data.get(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.editable && this.columns.get(columnIndex).isEditable(this.data.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.columns.get(columnIndex).setValue(this.data.get(rowIndex), aValue);
        this.fireTableDataChanged();
    }
}

