/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ETableModelColumn<T> {
    public String getTitle();

    public Object getValue(T var1);

    default public Class<?> getValueClass() {
        return Object.class;
    }

    default public boolean isEditable(T obj) {
        return false;
    }

    default public void setValue(T obj, Object value) {
        throw new RuntimeException();
    }

    public static <T> ETableModelColumn<T> create(String title, Function<T, Object> getValue) {
        return ETableModelColumn.create(title, Object.class, getValue);
    }

    public static <T> ETableModelColumn<T> create(final String title, final Class<?> cls, final Function<T, Object> getValue) {
        return new ETableModelColumn<T>(){

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public Object getValue(T obj) {
                return getValue.apply(obj);
            }

            @Override
            public Class<?> getValueClass() {
                return cls;
            }
        };
    }

    public static <T> ETableModelColumn<T> create(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue) {
        return ETableModelColumn.create(title, Object.class, getValue, setValue);
    }

    public static <T> ETableModelColumn<T> create(final String title, final Class<?> cls, final Function<T, Object> getValue, final BiConsumer<T, Object> setValue) {
        return new ETableModelColumn<T>(){

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public Object getValue(T obj) {
                return getValue.apply(obj);
            }

            @Override
            public Class<?> getValueClass() {
                return cls;
            }

            @Override
            public boolean isEditable(T obj) {
                return true;
            }

            @Override
            public void setValue(T obj, Object value) {
                setValue.accept(obj, value);
            }
        };
    }

    public static <T> ETableModelColumn<T> create(String title, Function<T, Object> getValue, BiConsumer<T, Object> setValue, Predicate<T> isEditable) {
        return ETableModelColumn.create(title, Object.class, getValue, setValue, isEditable);
    }

    public static <T> ETableModelColumn<T> create(final String title, final Class<?> cls, final Function<T, Object> getValue, final BiConsumer<T, Object> setValue, final Predicate<T> isEditable) {
        return new ETableModelColumn<T>(){

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public Object getValue(T obj) {
                return getValue.apply(obj);
            }

            @Override
            public Class<?> getValueClass() {
                return cls;
            }

            @Override
            public boolean isEditable(T obj) {
                return isEditable.test(obj);
            }

            @Override
            public void setValue(T obj, Object value) {
                setValue.accept(obj, value);
            }
        };
    }
}

