/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;

public class ETextArea
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private JPopupMenu popup;
    private List<JMenuItem> popup_editing;

    public ETextArea() {
        this.init();
    }

    public ETextArea(Document doc) {
        super(doc);
        this.init();
    }

    public ETextArea(String text) {
        super(text);
        this.init();
    }

    public ETextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public ETextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.init();
    }

    public ETextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.init();
    }

    private void init() {
        this.popup = new JPopupMenu();
        this.popup_editing = new ArrayList<JMenuItem>();
        this.setComponentPopupMenu(this.popup);
        DefaultEditorKit.CutAction action_cut = new DefaultEditorKit.CutAction();
        action_cut.putValue("Name", this.BUNDLE.getString("edvj.generic.menu.cut"));
        action_cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
        this.addPopupMenuItem(new JMenuItem(action_cut), true);
        DefaultEditorKit.CopyAction action_copy = new DefaultEditorKit.CopyAction();
        action_copy.putValue("Name", this.BUNDLE.getString("edvj.generic.menu.copy"));
        action_copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        this.addPopupMenuItem(new JMenuItem(action_copy), false);
        DefaultEditorKit.PasteAction action_paste = new DefaultEditorKit.PasteAction();
        action_paste.putValue("Name", this.BUNDLE.getString("edvj.generic.menu.paste"));
        action_paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        this.addPopupMenuItem(new JMenuItem(action_paste), true);
        JMenuItem mnu_delete = new JMenuItem(this.BUNDLE.getString("edvj.generic.menu.delete"));
        mnu_delete.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        mnu_delete.addActionListener(e -> {
            this.replaceSelection("");
            this.requestFocusInWindow();
        });
        this.addPopupMenuItem(mnu_delete, true);
        JMenuItem mnu_select_all = new JMenuItem(this.BUNDLE.getString("edvj.generic.menu.select_all"));
        mnu_select_all.setAccelerator(KeyStroke.getKeyStroke("control A"));
        mnu_select_all.addActionListener(e -> {
            this.selectAll();
            this.requestFocusInWindow();
        });
        this.addPopupMenuItem(mnu_select_all, false);
    }

    public void addPopupMenuSeparator() {
        this.popup.addSeparator();
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.addPopupMenuItem(item, false);
    }

    public void addPopupMenuItem(JMenuItem item, boolean editing) {
        this.popup.add(item);
        if (editing) {
            this.popup_editing.add(item);
            item.setEnabled(this.isEditable());
        }
    }

    public void addPopupMenuItem(String title, ActionListener action) {
        this.addPopupMenuItem(title, false, action);
    }

    public void addPopupMenuItem(String title, boolean editing, ActionListener action) {
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(action);
        this.addPopupMenuItem(item, editing);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.popup_editing != null) {
            for (JMenuItem next : this.popup_editing) {
                next.setEnabled(editable);
            }
        }
    }
}

