/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.gui.ETreeCellRenderer;
import de.inahware.edvj.gui.ETreeModel;
import de.inahware.edvj.gui.ETreeNode;
import de.inahware.edvj.gui.EUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.function.FailableConsumer;

public class ETree<T>
extends JTree {
    private static final long serialVersionUID = 1L;
    private ETreeModel<T> model = new ETreeModel<Object>(new ETreeNode<Object>(false, null));
    private JPopupMenu popup = new JPopupMenu();
    private List<FailableConsumer<ETreeNode<T>, Exception>> action_select = new ArrayList<FailableConsumer<ETreeNode<T>, Exception>>();
    private List<FailableConsumer<ETreeNode<T>, Exception>> action_doubleclick = new ArrayList<FailableConsumer<ETreeNode<T>, Exception>>();

    public ETree() {
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ETreeNode selected;
                if (e.getButton() == 1 && e.getClickCount() == 2 && (selected = ETree.this.getSelectedNode()) != null) {
                    for (FailableConsumer action : ETree.this.action_doubleclick) {
                        EUtils.catchWithDialog(ETree.this, () -> action.accept(selected));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseEvent(e);
            }

            private void mouseEvent(MouseEvent e) {
                int r = ETree.this.getRowForLocation(e.getX(), e.getY());
                if (r >= 0 && r < ETree.this.getRowCount()) {
                    ETree.this.setSelectionRow(r);
                }
                if (e.isPopupTrigger() && ETree.this.popup.getSubElements().length != 0) {
                    ETree.this.popup.show(ETree.this, e.getX(), e.getY());
                }
            }
        });
        this.getSelectionModel().addTreeSelectionListener(e -> this.fireSelect());
    }

    private void fireSelect() {
        ETreeNode selected = this.getSelectedNode();
        for (FailableConsumer action : this.action_select) {
            EUtils.catchWithDialog(this, () -> action.accept(selected));
        }
    }

    @Override
    public ETreeModel<T> getModel() {
        return this.model;
    }

    public void setModel(ETreeModel<T> model) {
        this.model = model;
        super.setModel(model);
        this.fireSelect();
    }

    @Override
    public void setModel(TreeModel model) {
        this.model = null;
        super.setModel(model);
    }

    public ETreeCellRenderer<T> setFormatter(Function<ETreeNode<T>, Object> formatter) {
        ETreeCellRenderer<T> renderer = new ETreeCellRenderer<T>(formatter);
        this.setCellRenderer(renderer);
        return renderer;
    }

    public ETreeNode<T> getRoot() {
        return this.model.getRoot();
    }

    public void setRoot(ETreeNode<T> node) {
        this.model.setRoot(node);
        this.fireSelect();
    }

    public ETreeNode<T> getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (ETreeNode)path.getLastPathComponent();
    }

    public T getSelectedValue() {
        ETreeNode<T> selected = this.getSelectedNode();
        if (selected == null) {
            return null;
        }
        return selected.getValue();
    }

    public void addPopupMenuItem(JMenuItem item) {
        this.popup.add(item);
    }

    public void addPopupMenuItem(String text, FailableConsumer<ETreeNode<T>, Exception> action) {
        JMenuItem item = new JMenuItem(text);
        this.connect(item, action);
        this.addPopupMenuItem(item);
    }

    public void addPopupMenuItem(String text, Predicate<ETreeNode<T>> cond, FailableConsumer<ETreeNode<T>, Exception> action) {
        JMenuItem item = new JMenuItem(text);
        this.connect(item, cond, action);
        this.addPopupMenuItem(item);
    }

    public void addSelectAction(FailableConsumer<ETreeNode<T>, Exception> action) {
        this.action_select.add(action);
    }

    public void addDoubleClickAction(FailableConsumer<ETreeNode<T>, Exception> action) {
        this.action_doubleclick.add(action);
    }

    public void connect(AbstractButton btn, FailableConsumer<ETreeNode<T>, Exception> action) {
        btn.addActionListener(e -> EUtils.catchWithDialog(btn, () -> action.accept(this.getSelectedNode())));
    }

    public void connect(AbstractButton btn, Predicate<ETreeNode<T>> cond, FailableConsumer<ETreeNode<T>, Exception> action) {
        this.addSelectAction(node -> btn.setEnabled(cond.test((ETreeNode)node)));
        btn.setEnabled(cond.test(this.getSelectedNode()));
        this.connect(btn, action);
    }
}

