/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.gui.ETreeNode;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ETreeModel<T>
implements TreeModel {
    private ETreeNode<T> root;
    private Set<TreeModelListener> listeners = new HashSet<TreeModelListener>();
    private TreeModelListener root_listener = new TreeModelListener(){

        @Override
        public void treeNodesInserted(TreeModelEvent ev) {
            for (TreeModelListener listener : ETreeModel.this.listeners) {
                listener.treeNodesInserted(ev);
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent ev) {
            for (TreeModelListener listener : ETreeModel.this.listeners) {
                listener.treeNodesChanged(ev);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent ev) {
            for (TreeModelListener listener : ETreeModel.this.listeners) {
                listener.treeNodesRemoved(ev);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent ev) {
            for (TreeModelListener listener : ETreeModel.this.listeners) {
                listener.treeStructureChanged(ev);
            }
        }
    };

    public ETreeModel(ETreeNode<T> root) {
        this.setRoot(root);
    }

    @Override
    public ETreeNode<T> getRoot() {
        return this.root;
    }

    public void setRoot(ETreeNode<T> node) {
        if (this.root != null) {
            this.root.removeTreeModelListener(this.root_listener);
        }
        if (node != null) {
            this.root = node;
            this.root.addTreeModelListener(this.root_listener);
        }
        this.refresh();
    }

    @Override
    public ETreeNode<T> getChild(Object obj, int idx) {
        ETreeNode node = (ETreeNode)obj;
        return node.getChildAt(idx);
    }

    @Override
    public int getChildCount(Object obj) {
        ETreeNode node = (ETreeNode)obj;
        return node.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object obj1, Object obj2) {
        ETreeNode node1 = (ETreeNode)obj1;
        ETreeNode node2 = (ETreeNode)obj2;
        for (int i = 0; i < node1.getChildCount(); ++i) {
            if (node1.getChildAt(i) != node2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object obj) {
        ETreeNode node = (ETreeNode)obj;
        return node.isLeaf();
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    public void refresh() {
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(new TreeModelEvent(this.root, new Object[]{this.root}));
        }
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }
}

