/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ETreeNode<T>
implements TreeNode {
    private ETreeNode<T> parent = null;
    private boolean leaf;
    private T value;
    private Set<TreeModelListener> listeners;
    private List<ETreeNode<T>> children;

    public ETreeNode(boolean leaf, T value) {
        this.leaf = leaf;
        this.value = value;
        this.listeners = new HashSet<TreeModelListener>();
        this.children = new ArrayList<ETreeNode<T>>();
    }

    @Override
    public ETreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(ETreeNode<T> node) {
        this.parent = node;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.leaf;
    }

    public void setLeaf(boolean leaf) {
        if (!this.leaf && leaf && !this.children.isEmpty()) {
            throw new RuntimeException();
        }
        if (this.leaf != leaf) {
            this.leaf = leaf;
            this.refresh();
        }
    }

    public Enumeration<ETreeNode<T>> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ETreeNode<T> getChildAt(int idx) {
        return this.children.get(idx);
    }

    @Override
    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != node) continue;
            return i;
        }
        return -1;
    }

    public void addChild(ETreeNode<T> node) {
        this.addChild(this.children.size(), node);
    }

    public void addChild(int idx, ETreeNode<T> node) {
        if (this.leaf) {
            throw new RuntimeException();
        }
        if (node.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.children.add(idx, node);
        node.setParent(this);
        TreePath path = new TreePath(this.getPath());
        this.fireEvent(listener -> listener.treeNodesInserted(new TreeModelEvent((Object)this, path, new int[]{idx}, new Object[]{node})));
    }

    public void removeChild(int idx) {
        ETreeNode<T> node = this.children.remove(idx);
        node.setParent(null);
        TreePath path = new TreePath(this.getPath());
        this.fireEvent(listener -> listener.treeNodesRemoved(new TreeModelEvent((Object)this, path, new int[]{idx}, new Object[]{node})));
    }

    public void removeChild(ETreeNode<T> node) {
        this.removeChild(this.getIndex(node));
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.refresh();
    }

    public void refresh() {
        int[] idx;
        TreePath path;
        if (this.parent == null) {
            path = null;
            idx = null;
        } else {
            path = new TreePath(this.getPath()).getParentPath();
            idx = new int[]{this.parent.getIndex(this)};
        }
        this.fireEvent(listener -> listener.treeNodesChanged(new TreeModelEvent((Object)this, path, idx, new Object[]{this})));
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }

    public TreeNode[] getPath() {
        ArrayList<ETreeNode<TreeNode>> path = new ArrayList<ETreeNode<TreeNode>>();
        this.buildPath(path);
        return path.toArray(new TreeNode[0]);
    }

    private void buildPath(List<ETreeNode<T>> path) {
        if (this.parent != null) {
            this.parent.buildPath(path);
        }
        path.add(this);
    }

    private void fireEvent(Consumer<TreeModelListener> f) {
        for (TreeModelListener listener : this.listeners) {
            f.accept(listener);
        }
        if (this.parent != null) {
            this.parent.fireEvent(f);
        }
    }
}

