/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.BlockingDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableRunnable;

public class EUtils {
    public static void catchSilently(FailableRunnable<Exception> run) {
        try {
            run.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void catchWithDialog(FailableRunnable<Exception> run) {
        try {
            run.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                SwingUtilities.invokeAndWait(() -> EUtils.showErrorDialog(null, ex));
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void catchWithDialog(Component parent, FailableRunnable<Exception> run) {
        try {
            run.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EUtils.showErrorDialog(parent, ex);
        }
    }

    public static void blocking(Component parent, FailableConsumer<BlockingDialog<Void>, Exception> fn) throws Exception {
        EUtils.blocking(parent, (BlockingDialog<T> blocking) -> {
            fn.accept((BlockingDialog<Void>)blocking);
            return null;
        });
    }

    public static void blocking(Component parent, String message, FailableConsumer<BlockingDialog<Void>, Exception> fn) throws Exception {
        EUtils.blocking(parent, message, (BlockingDialog<T> blocking) -> {
            fn.accept((BlockingDialog<Void>)blocking);
            return null;
        });
    }

    public static void blocking(Component parent, String title, String message, FailableConsumer<BlockingDialog<Void>, Exception> fn) throws Exception {
        EUtils.blocking(parent, title, message, (BlockingDialog<T> blocking) -> {
            fn.accept((BlockingDialog<Void>)blocking);
            return null;
        });
    }

    public static <T> T blocking(Component parent, FailableFunction<BlockingDialog<T>, T, Exception> fn) throws Exception {
        ResourceBundle BUNDLE = I18N.getBundle();
        return EUtils.blocking(parent, BUNDLE.getString("edvj.generic.messages.blocking"), fn);
    }

    public static <T> T blocking(Component parent, String message, FailableFunction<BlockingDialog<T>, T, Exception> fn) throws Exception {
        Window window = SwingUtilities.windowForComponent(parent);
        String title = EUtils.getWindowTitle(window);
        return EUtils.blocking(parent, title, message, fn);
    }

    public static <T> T blocking(Component parent, String title, String message, final FailableFunction<BlockingDialog<T>, T, Exception> fn) throws Exception {
        Window parentWindow = SwingUtilities.windowForComponent(parent);
        BlockingDialog dialog = new BlockingDialog<T>(parentWindow, title, message){
            private static final long serialVersionUID = 1L;

            @Override
            protected T run() throws Exception {
                return fn.apply(this);
            }
        };
        return dialog.input();
    }

    public static void blockingCatchSilently(Component parent, FailableConsumer<BlockingDialog<Void>, Exception> fn) {
        EUtils.catchSilently(() -> EUtils.blocking(parent, fn));
    }

    public static void blockingCatchSilently(Component parent, String message, FailableConsumer<BlockingDialog<Void>, Exception> fn) {
        EUtils.catchSilently(() -> EUtils.blocking(parent, message, fn));
    }

    public static void blockingCatchSilently(Component parent, String title, String message, FailableConsumer<BlockingDialog<Void>, Exception> fn) {
        EUtils.catchSilently(() -> EUtils.blocking(parent, title, message, fn));
    }

    public static void blockingCatchWithDialog(Component parent, FailableConsumer<BlockingDialog<Void>, Exception> fn) {
        EUtils.catchWithDialog(parent, () -> EUtils.blocking(parent, fn));
    }

    public static void blockingCatchWithDialog(Component parent, String message, FailableConsumer<BlockingDialog<Void>, Exception> fn) {
        EUtils.catchWithDialog(parent, () -> EUtils.blocking(parent, message, fn));
    }

    public static void blockingCatchWithDialog(Component parent, String title, String message, FailableConsumer<BlockingDialog<Void>, Exception> fn) {
        EUtils.catchWithDialog(parent, () -> EUtils.blocking(parent, title, message, fn));
    }

    public static void showMessageDialog(Component parent, Object message) {
        EUtils.showMessageDialog(parent, message, 1);
    }

    public static void showMessageDialog(Component parent, Object message, int type) {
        Window window = parent != null ? SwingUtilities.windowForComponent(parent) : null;
        String title = window != null ? EUtils.getWindowTitle(window) : "";
        JOptionPane.showMessageDialog(window, message, title, type);
    }

    public static void showInfoDialog(Component parent, Object message) {
        Window window = parent != null ? SwingUtilities.windowForComponent(parent) : null;
        String title = window != null ? EUtils.getWindowTitle(window) : "";
        JOptionPane.showMessageDialog(window, message, title, 1);
    }

    public static void showWarningDialog(Component parent, Object message) {
        ResourceBundle BUNDLE = I18N.getBundle();
        EUtils.showMessageDialog(parent, message, BUNDLE.getString("edvj.generic.title.warning"), 2);
    }

    public static void showErrorDialog(Component parent, Exception ex) {
        ResourceBundle BUNDLE = I18N.getBundle();
        String message = ex.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            EUtils.showErrorDialog(parent, BUNDLE.getString("edvj.generic.messages.error"));
        } else {
            EUtils.showErrorDialog(parent, message);
        }
    }

    public static void showErrorDialog(Component parent, Object message) {
        ResourceBundle BUNDLE = I18N.getBundle();
        EUtils.showMessageDialog(parent, message, BUNDLE.getString("edvj.generic.title.error"), 0);
    }

    public static void showMessageDialog(Component parent, Object message, String title, int type) {
        Window window = parent != null ? SwingUtilities.windowForComponent(parent) : null;
        JOptionPane.showMessageDialog(window, message, title, type);
    }

    public static String getWindowTitle(Window window) {
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            return frame.getTitle();
        }
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            return dialog.getTitle();
        }
        return null;
    }
}

