/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.EUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.function.FailableConsumer;

public abstract class EditDialog<T>
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private T obj;
    private T placeholder;
    private T displayed;
    private T returned;
    private boolean immediate;
    private List<FailableConsumer<Boolean, Exception>> editable;
    private Set<JComponent> editable_enabled;
    private List<FailableConsumer<T, Exception>> savedListeners;
    private boolean editing;
    private String baseTitle;
    protected final JPanel rootPanel = new JPanel();
    protected final JPanel bottomPanel = new JPanel();
    private JPanel panel_buttons;
    private JPanel panel_buttons1;
    private JButton btnEdit;
    private JButton btnClose;
    private JPanel panel_buttons2;
    private JButton btnSave;
    private JButton btnCancel;
    private JPanel panel;

    protected EditDialog() {
        this.createContents();
    }

    public EditDialog(T obj) {
        this(obj, null);
    }

    public EditDialog(T obj0, T placeholder) {
        this.obj = obj0;
        this.placeholder = placeholder;
        this.immediate = false;
        this.editable = new ArrayList<FailableConsumer<Boolean, Exception>>();
        this.editable_enabled = new HashSet<JComponent>();
        this.savedListeners = new ArrayList<FailableConsumer<T, Exception>>();
        this.editing = false;
        this.baseTitle = "";
        this.setWindowSize(640, 320);
        this.createContents();
        this.addOpenListener(() -> {
            this.displayObject();
            if (this.obj == null || this.immediate) {
                this.setEditing(true);
            } else {
                this.setEditing(false);
            }
        });
        this.addClosingListener(() -> {
            if (!this.immediate) {
                this.returned = this.obj;
            }
        });
        this.btnEdit.addActionListener(ev -> this.setEditing(true));
        this.btnClose.addActionListener(ev -> this.close());
        this.btnSave.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            T obj2 = this.parseObject(this.displayed);
            if (obj2 != null) {
                this.saveObject(this.obj, obj2);
            }
        }));
        this.btnCancel.addActionListener(ev -> {
            if (this.getObject() == null || this.immediate) {
                this.close();
            } else {
                this.displayObject();
                this.setEditing(false);
            }
        });
    }

    private void createContents() {
        this.add((Component)this.rootPanel, "Center");
        this.panel = new JPanel();
        this.add((Component)this.panel, "South");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel.add((Component)this.bottomPanel, "Center");
        this.panel_buttons = new JPanel();
        this.panel.add((Component)this.panel_buttons, "East");
        this.panel_buttons.setLayout(new CardLayout(0, 0));
        this.panel_buttons1 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_buttons1.getLayout();
        flowLayout.setAlignment(2);
        this.panel_buttons.add(this.panel_buttons1);
        this.btnEdit = new JButton(this.BUNDLE.getString("edvj.generic.button.edit"));
        this.panel_buttons1.add(this.btnEdit);
        this.btnClose = new JButton(this.BUNDLE.getString("edvj.generic.button.close"));
        this.panel_buttons1.add(this.btnClose);
        this.panel_buttons2 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.panel_buttons2.getLayout();
        flowLayout_1.setAlignment(2);
        this.panel_buttons.add(this.panel_buttons2);
        this.btnSave = new JButton(this.BUNDLE.getString("edvj.generic.button.save"));
        this.panel_buttons2.add(this.btnSave);
        this.btnCancel = new JButton(this.BUNDLE.getString("edvj.generic.button.cancel"));
        this.panel_buttons2.add(this.btnCancel);
    }

    public T getObject() {
        return this.obj;
    }

    public T getDisplayedObject() {
        return this.displayed;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean value) {
        this.immediate = value;
    }

    public boolean isEditable() {
        return this.btnEdit.isEnabled();
    }

    public void setEditable(boolean value) {
        this.btnEdit.setEnabled(value);
    }

    public void addSavedListener(FailableConsumer<T, Exception> c) {
        this.savedListeners.add(c);
    }

    protected void addEditable(JTextComponent c) {
        this.addEditable((Boolean editable) -> c.setEditable(this.editable_enabled.contains(c) && editable != false));
        this.editable_enabled.add(c);
    }

    protected void addEditable(ETable<?> c) {
        this.addEditable((Boolean editable) -> c.setEditable(this.editable_enabled.contains(c) && editable != false));
        this.editable_enabled.add(c);
    }

    protected void addEditable(JComponent c) {
        this.addEditable((Boolean editable) -> c.setEnabled(this.editable_enabled.contains(c) && editable != false));
        this.editable_enabled.add(c);
    }

    protected void addReadOnly(JComponent c) {
        this.addEditable((Boolean editable) -> c.setEnabled(this.editable_enabled.contains(c) && editable == false));
        this.editable_enabled.add(c);
    }

    protected void addEditable(FailableConsumer<Boolean, Exception> toggle) {
        this.editable.add(toggle);
    }

    protected boolean isEnabled(JComponent c) {
        return this.editable_enabled.contains(c);
    }

    protected void setEnabled(JComponent c, boolean editable) {
        if (editable) {
            this.editable_enabled.add(c);
        } else {
            this.editable_enabled.remove(c);
        }
        this.setEditing(this.editing);
    }

    protected void setEditing(boolean editing) {
        this.editing = editing;
        this.updateTitle();
        for (FailableConsumer<Boolean, Exception> toggle : this.editable) {
            EUtils.catchWithDialog(this, () -> toggle.accept(editing));
        }
        CardLayout card = (CardLayout)this.panel_buttons.getLayout();
        if (editing) {
            card.last(this.panel_buttons);
        } else {
            card.first(this.panel_buttons);
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    private void displayObject() {
        try {
            this.displayed = this.obj == null ? this.placeholder : this.obj;
            this.displayObject(this.displayed);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EUtils.showErrorDialog((Component)this, ex);
            this.close();
        }
    }

    @Override
    public void setTitle(String title) {
        this.baseTitle = title;
        this.updateTitle();
    }

    private void updateTitle() {
        if (!this.immediate && this.editing) {
            super.setTitle(this.baseTitle + " [" + this.BUNDLE.getString("edvj.generic.title.editing") + "]");
        } else {
            super.setTitle(this.baseTitle);
        }
    }

    public T inputDialog(Component parent) {
        return this.inputDialog(parent, true);
    }

    public T inputDialog(Component parent, boolean immediate) {
        if (immediate) {
            this.setImmediate(true);
        }
        this.intoModalDialog(parent).setVisible(true);
        return this.returned;
    }

    public void inputPage(EFrame parent, FailableConsumer<T, Exception> action) {
        this.inputPage(parent, true, action);
    }

    public void inputPage(EFrame parent, boolean immediate, FailableConsumer<T, Exception> action) {
        if (immediate) {
            this.setImmediate(true);
        }
        this.openPage(parent, () -> action.accept(this.returned));
    }

    public void inputInnerModal(EFrame parent, FailableConsumer<T, Exception> action) {
        this.inputInnerModal(parent, true, action);
    }

    public void inputInnerModal(EFrame parent, boolean immediate, FailableConsumer<T, Exception> action) {
        if (immediate) {
            this.setImmediate(true);
        }
        this.openInnerModal(parent, () -> action.accept(this.returned));
    }

    protected abstract void displayObject(T var1) throws Exception;

    protected abstract T parseObject(T var1) throws Exception;

    protected void saveObject(T old, T obj) throws Exception {
        this.objectSaved(obj);
    }

    protected void objectSaved(T obj) {
        this.obj = obj;
        if (this.immediate) {
            this.returned = this.obj;
            this.close();
        } else {
            this.displayObject();
            this.setEditing(false);
            for (FailableConsumer c : this.savedListeners) {
                EUtils.catchWithDialog(this, () -> c.accept(obj));
            }
        }
    }
}

