/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.lang3.function.FailableConsumer;

public abstract class InputDialog<T>
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = I18N.getBundle();
    private T returned = null;
    protected final JPanel rootPanel = new JPanel();
    protected final JPanel bottomPanel = new JPanel();
    private JPanel panel;
    private JPanel panel_buttons;
    private JButton btnOk;
    private JButton btnCancel;

    public InputDialog() {
        this.setWindowSize(640, 320);
        this.createContents();
        this.setDefaultButton(this.btnOk);
        this.btnOk.addActionListener(ev -> EUtils.catchWithDialog(this, () -> this.returnObject()));
        this.btnCancel.addActionListener(ev -> this.close());
    }

    private void createContents() {
        this.add((Component)this.rootPanel, "Center");
        this.panel = new JPanel();
        this.add((Component)this.panel, "South");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel.add((Component)this.bottomPanel, "Center");
        this.panel_buttons = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_buttons.getLayout();
        flowLayout.setAlignment(2);
        this.panel.add((Component)this.panel_buttons, "East");
        this.btnOk = new JButton(this.BUNDLE.getString("edvj.generic.button.ok"));
        this.panel_buttons.add(this.btnOk);
        this.btnCancel = new JButton(this.BUNDLE.getString("edvj.generic.button.cancel"));
        this.panel_buttons.add(this.btnCancel);
    }

    public T getReturnedObject() {
        return this.returned;
    }

    protected void returnObject() throws Exception {
        this.returnObject(this.parseObject());
    }

    protected void returnObject(T obj) {
        this.returned = obj;
        this.close();
    }

    public T inputDialog(Component parent) {
        this.intoModalDialog(parent).setVisible(true);
        return this.returned;
    }

    public void inputPage(EFrame parent, FailableConsumer<T, Exception> action) {
        this.openPage(parent, () -> action.accept(this.returned));
    }

    public void inputInnerModal(EFrame parent, FailableConsumer<T, Exception> action) {
        this.openInnerModal(parent, () -> action.accept(this.returned));
    }

    protected abstract T parseObject() throws Exception;
}

