/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.gui;

import de.inahware.edvj.gui.EUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.function.FailableRunnable;

public class MainMenuItem {
    private String title;
    private BooleanSupplier cond;
    private List<MainMenuItem> childs;
    private FailableRunnable<Exception> action;

    public MainMenuItem() {
        this(null, () -> true);
    }

    public MainMenuItem(String title, BooleanSupplier cond) {
        this.title = title;
        this.cond = cond;
        this.childs = new ArrayList<MainMenuItem>();
        this.action = null;
    }

    public MainMenuItem(String title, BooleanSupplier cond, FailableRunnable<Exception> action) {
        this.title = title;
        this.cond = cond;
        this.childs = null;
        this.action = action;
    }

    public boolean isGroup() {
        return this.childs != null;
    }

    public void addSeperator() {
        this.childs.add(null);
    }

    public boolean checkCondition() {
        return this.cond.getAsBoolean();
    }

    public MainMenuItem add(MainMenuItem item) {
        this.childs.add(item);
        return item;
    }

    public MainMenuItem addGroup(String title) {
        return this.add(new MainMenuItem(title, () -> true));
    }

    public MainMenuItem addGroup(String title, BooleanSupplier cond) {
        return this.add(new MainMenuItem(title, cond));
    }

    public MainMenuItem add(String title, FailableRunnable<Exception> action) {
        return this.add(new MainMenuItem(title, () -> true, action));
    }

    public MainMenuItem add(String title, BooleanSupplier cond, FailableRunnable<Exception> action) {
        return this.add(new MainMenuItem(title, cond, action));
    }

    public MainMenuItem filtered() {
        if (!this.checkCondition()) {
            return null;
        }
        if (!this.isGroup()) {
            return this;
        }
        ArrayList<MainMenuItem> childs = new ArrayList<MainMenuItem>();
        boolean wasSeparator = true;
        for (MainMenuItem next : this.childs) {
            if (next == null) {
                if (!wasSeparator) {
                    childs.add(null);
                }
                wasSeparator = true;
                continue;
            }
            if ((next = next.filtered()) == null) continue;
            wasSeparator = false;
            childs.add(next);
        }
        if (childs.isEmpty()) {
            return null;
        }
        if (wasSeparator) {
            childs.remove(childs.size() - 1);
        }
        MainMenuItem res = new MainMenuItem(this.title, this.cond);
        for (MainMenuItem next : childs) {
            res.add(next);
        }
        return res;
    }

    public void renderIntoPanel(JPanel panel) {
        if (!this.isGroup()) {
            throw new RuntimeException();
        }
        for (MainMenuItem child : this.childs) {
            panel.add(child.renderPanel());
        }
    }

    public void renderIntoMenu(JMenu menu) {
        if (!this.isGroup()) {
            throw new RuntimeException();
        }
        for (MainMenuItem child : this.childs) {
            menu.add(child.renderMenuItem());
        }
    }

    public JPanel renderPanel() {
        if (!this.isGroup()) {
            throw new RuntimeException();
        }
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(null, this.title, 4, 2));
        panel.setLayout(new MigLayout("", "[175px]", "[30px]".repeat(this.childs.size())));
        for (int i = 0; i < this.childs.size(); ++i) {
            MainMenuItem child = this.childs.get(i);
            if (child == null) continue;
            panel.add((Component)child.renderButton(), "cell 0 " + i + ",grow");
        }
        return panel;
    }

    public JButton renderButton() {
        final JButton btn = new JButton(this.title);
        if (this.isGroup()) {
            final JPopupMenu popup = new JPopupMenu();
            for (MainMenuItem child : this.childs) {
                if (child == null) {
                    popup.addSeparator();
                    continue;
                }
                popup.add(child.renderMenuItem());
            }
            btn.addActionListener(e -> popup.show(btn, 0, btn.getHeight()));
            btn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popup.show(btn, e.getX(), e.getY());
                    } else {
                        popup.show(btn, 0, btn.getHeight());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popup.show(btn, e.getX(), e.getY());
                    }
                }
            });
        } else if (this.action != null) {
            btn.addActionListener(e -> EUtils.catchWithDialog(btn, this.action));
        }
        return btn;
    }

    public JMenuItem renderMenuItem() {
        if (this.isGroup()) {
            JMenu mnu = new JMenu(this.title);
            for (MainMenuItem child : this.childs) {
                if (child == null) {
                    mnu.addSeparator();
                    continue;
                }
                mnu.add(child.renderMenuItem());
            }
            return mnu;
        }
        JMenuItem item = new JMenuItem(this.title);
        if (this.action != null) {
            item.addActionListener(e -> EUtils.catchWithDialog(item, this.action));
        }
        return item;
    }
}

