/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.launcher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.inahware.edvj.launcher.LauncherProtocol;
import java.nio.file.Path;
import org.apache.commons.lang3.SystemUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LauncherProfile {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(((JsonFactoryBuilder)((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().disable(StreamWriteFeature.AUTO_CLOSE_TARGET)).enable(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN)).disable(StreamReadFeature.AUTO_CLOSE_SOURCE)).build()).registerModule(new JavaTimeModule());
    @JsonIgnore
    private Path path;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="server_protocol")
    private LauncherProtocol serverProtocol;
    @JsonProperty(value="server_url")
    private String serverUrl;
    @JsonProperty(value="server_args")
    private String serverArgs;
    @JsonProperty(value="server_cert_file")
    private String serverCertFile;
    @JsonProperty(value="cmd_line_linux")
    private String[] cmdLineLinux;
    @JsonProperty(value="cmd_line_windows")
    private String[] cmdLineWindows;
    @JsonProperty(value="cmd_line_macos")
    private String[] cmdLineMacOS;

    private LauncherProfile() {
    }

    public LauncherProfile(String name, LauncherProtocol serverProtocol, String serverUrl, String serverArgs, String serverCertFile, String[] cmdLineLinux, String[] cmdLineWindows, String[] cmdLineMacOS) {
        this.name = name;
        this.serverProtocol = serverProtocol;
        this.serverUrl = serverUrl;
        this.serverArgs = serverArgs;
        this.serverCertFile = serverCertFile;
        this.cmdLineLinux = (String[])cmdLineLinux.clone();
        this.cmdLineWindows = (String[])cmdLineWindows.clone();
        this.cmdLineMacOS = (String[])cmdLineMacOS.clone();
    }

    public LauncherProfile(LauncherProfile profile) {
        this.path = profile.path;
        this.serverProtocol = profile.serverProtocol;
        this.serverUrl = profile.serverUrl;
        this.serverArgs = profile.serverArgs;
        this.serverCertFile = profile.serverCertFile;
        this.cmdLineLinux = (String[])profile.cmdLineLinux.clone();
        this.cmdLineWindows = (String[])profile.cmdLineWindows.clone();
        this.cmdLineMacOS = (String[])profile.cmdLineMacOS.clone();
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public LauncherProtocol getServerProtocol() {
        return this.serverProtocol;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerArgs() {
        return this.serverArgs;
    }

    public String getServerCertFile() {
        return this.serverCertFile;
    }

    public String[] getCmdLineLinux() {
        return this.cmdLineLinux;
    }

    public String[] getCmdLineWindows() {
        return this.cmdLineWindows;
    }

    public String[] getCmdLineMacOS() {
        return this.cmdLineMacOS;
    }

    @JsonIgnore
    public String[] getCmdLine() {
        if (SystemUtils.IS_OS_LINUX) {
            return this.cmdLineLinux;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.cmdLineWindows;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return this.cmdLineMacOS;
        }
        return null;
    }

    public String toJson() throws Exception {
        return OBJECT_MAPPER.writeValueAsString(this);
    }

    public static LauncherProfile load(Path path) throws Exception {
        LauncherProfile profile = OBJECT_MAPPER.readValue(path.resolve("launcher.json").toFile(), LauncherProfile.class);
        profile.path = path;
        LauncherProfile.checkExecPath(Path.of(profile.getCmdLineLinux()[0], new String[0]));
        LauncherProfile.checkExecPath(Path.of(profile.getCmdLineWindows()[0], new String[0]));
        LauncherProfile.checkExecPath(Path.of(profile.getCmdLineMacOS()[0], new String[0]));
        return profile;
    }

    private static void checkExecPath(Path path) throws Exception {
        if (path.isAbsolute()) {
            throw new RuntimeException("invalid profile");
        }
        if (path.normalize().startsWith("..")) {
            throw new RuntimeException("invalid profile");
        }
    }
}

