/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedInsert;
import java.util.List;

public class Insert<T extends DataObject>
extends Query<T> {
    private DataModel<T> model;
    private T obj;

    public Insert(DataModel<T> model, T obj) {
        this.model = model;
        this.obj = obj;
    }

    public DataModel<T> getModel() {
        return this.model;
    }

    public T getObject() {
        return this.obj;
    }

    @Override
    public SerializedInsert serialize(ObjectMapper mapper) {
        Object obj = mapper.valueToTree(this.obj);
        return new SerializedInsert(this.model.getName(), (JsonNode)obj);
    }

    @Override
    public T deserializeResult(ObjectMapper mapper, String data) throws Exception {
        return (T)((DataObject)mapper.readValue(data, this.model.getObjectClass()));
    }

    @Override
    public <C extends QueryContext> T execute(DataModelMap<C> models, C ctx) throws Exception {
        DataController<T, C> impl = models.getController(this.model);
        List<T> res = impl.onInsertAll(ctx, List.of(this.obj));
        return (T)(res != null ? (DataObject)res.get(0) : null);
    }
}

