/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedInsertAll;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class InsertAll<T extends DataObject>
extends Query<ArrayList<T>> {
    private DataModel<T> model;
    private ArrayList<T> objs;

    public InsertAll(DataModel<T> model, T obj) {
        this(model, List.of(obj));
    }

    public InsertAll(DataModel<T> model, List<T> objs) {
        this.model = model;
        this.objs = new ArrayList<T>(objs);
    }

    public DataModel<T> getModel() {
        return this.model;
    }

    public List<T> getObjects() {
        return this.objs;
    }

    @Override
    public SerializedInsertAll serialize(ObjectMapper mapper) {
        ArrayList objs = this.objs.stream().map(obj -> mapper.valueToTree(obj)).collect(Collectors.toCollection(() -> new ArrayList()));
        return new SerializedInsertAll(this.model.getName(), objs);
    }

    @Override
    public ArrayList<T> deserializeResult(ObjectMapper mapper, String data) throws Exception {
        CollectionLikeType type = mapper.getTypeFactory().constructCollectionLikeType(ArrayList.class, this.model.getObjectClass());
        return (ArrayList)mapper.readValue(data, (JavaType)type);
    }

    @Override
    public <C extends QueryContext> ArrayList<T> execute(DataModelMap<C> models, C ctx) throws Exception {
        DataController<T, C> impl = models.getController(this.model);
        List<T> res = impl.onInsertAll(ctx, this.objs);
        return res != null ? new ArrayList<T>(res) : null;
    }
}

