/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedQuery;
import de.inahware.edvj.request.RequestException;
import de.inahware.edvj.request.RequestResponse;
import de.inahware.edvj.request.RequestResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHandler<C extends QueryContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryHandler.class.getName());
    private ObjectMapper mapper;
    private DataModelMap<C> models;

    public QueryHandler(ObjectMapper mapper, DataModelMap<C> models) {
        this.mapper = mapper;
        this.models = models;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public DataModelMap<C> getModelMap() {
        return this.models;
    }

    public RequestResponse execute(C ctx, String data) throws JsonProcessingException {
        try {
            Query<?> query;
            try {
                SerializedQuery serialized = this.mapper.readValue(data, SerializedQuery.class);
                query = serialized.deserialize(this.mapper, this.models);
            }
            catch (JsonProcessingException ex) {
                throw new RequestException();
            }
            Object res = query.execute(this.models, ctx);
            String json = this.mapper.writeValueAsString(res);
            return new RequestResponse(RequestResponseType.OK, json);
        }
        catch (RequestException ex) {
            LOGGER.debug("client error", ex);
            String json = this.mapper.writeValueAsString(ex.serialize());
            return new RequestResponse(RequestResponseType.CLIENT_ERROR, json);
        }
        catch (Exception ex) {
            LOGGER.error("server error", ex);
            RequestException ex2 = new RequestException("edvj.errors.server_error");
            String json = this.mapper.writeValueAsString(ex2.serialize());
            return new RequestResponse(RequestResponseType.SERVER_ERROR, json);
        }
    }
}

