/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedQueryList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class QueryList
extends Query<Void> {
    private ArrayList<Query<?>> queries;

    public QueryList(List<Query<?>> queries) {
        this.queries = new ArrayList(queries);
    }

    @Override
    public SerializedQueryList serialize(ObjectMapper mapper) {
        ArrayList queries = this.queries.stream().map(f -> f.serialize(mapper)).collect(Collectors.toCollection(() -> new ArrayList()));
        return new SerializedQueryList(queries);
    }

    @Override
    public Void deserializeResult(ObjectMapper mapper, String data) throws Exception {
        return mapper.readValue(data, Void.class);
    }

    @Override
    public <C extends QueryContext> Void execute(DataModelMap<C> models, C ctx) throws Exception {
        for (Query<?> q : this.queries) {
            q.execute(models, ctx);
        }
        return null;
    }
}

