/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedSelect;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.SerializedFilter;
import java.util.List;

public class Select<T extends DataObject>
extends Query<T> {
    private DataModel<T> model;
    private Filter filter;

    public Select(DataModel<T> model) {
        this(model, null);
    }

    public Select(DataModel<T> model, Filter filter) {
        this.model = model;
        this.filter = filter;
    }

    public DataModel<T> getModel() {
        return this.model;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SerializedSelect serialize(ObjectMapper mapper) {
        SerializedFilter filter = this.filter != null ? this.filter.serialize(mapper) : null;
        return new SerializedSelect(this.model.getName(), filter);
    }

    @Override
    public T deserializeResult(ObjectMapper mapper, String data) throws Exception {
        return (T)((DataObject)mapper.readValue(data, this.model.getObjectClass()));
    }

    @Override
    public <C extends QueryContext> T execute(DataModelMap<C> models, C ctx) throws Exception {
        DataController<T, C> impl = models.getController(this.model);
        List<T> res = impl.onSelectAll(ctx, this.filter, 0, 1);
        return (T)(res.size() != 0 ? (DataObject)res.get(0) : null);
    }
}

