/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedSelectAll;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.SerializedFilter;
import java.util.ArrayList;

public class SelectAll<T extends DataObject>
extends Query<ArrayList<T>> {
    private DataModel<T> model;
    private Filter filter;
    private int offset;
    private int limit;

    public SelectAll(DataModel<T> model) {
        this(model, null);
    }

    public SelectAll(DataModel<T> model, Filter filter) {
        this(model, filter, 0, -1);
    }

    public SelectAll(DataModel<T> model, int offset, int limit) {
        this(model, null, offset, limit);
    }

    public SelectAll(DataModel<T> model, Filter filter, int offset, int limit) {
        this.model = model;
        this.filter = filter;
        this.offset = offset;
        this.limit = limit;
    }

    public DataModel<T> getModel() {
        return this.model;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public SerializedSelectAll serialize(ObjectMapper mapper) {
        SerializedFilter filter = this.filter != null ? this.filter.serialize(mapper) : null;
        return new SerializedSelectAll(this.model.getName(), filter);
    }

    @Override
    public ArrayList<T> deserializeResult(ObjectMapper mapper, String data) throws Exception {
        CollectionLikeType type = mapper.getTypeFactory().constructCollectionLikeType(ArrayList.class, this.model.getObjectClass());
        return (ArrayList)mapper.readValue(data, (JavaType)type);
    }

    @Override
    public <C extends QueryContext> ArrayList<T> execute(DataModelMap<C> models, C ctx) throws Exception {
        DataController<T, C> impl = models.getController(this.model);
        return new ArrayList<T>(impl.onSelectAll(ctx, this.filter, this.offset, this.limit));
    }
}

