/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.Query;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.SerializedUpdate;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.SerializedFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Update<T extends DataObject>
extends Query<Void> {
    private DataModel<T> model;
    private final List<DataField<?>> fields;
    private final Filter filter;

    public Update(DataModel<T> model, T obj) {
        this(model, ((DataObject)obj).getFields(), ((DataObject)obj).getPrimaryFilter());
    }

    public Update(DataModel<T> model, List<DataField<?>> fields, Filter filter) {
        this.model = model;
        this.fields = fields;
        this.filter = filter;
    }

    public DataModel<T> getModel() {
        return this.model;
    }

    public List<DataField<?>> getFields() {
        return this.fields;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SerializedUpdate serialize(ObjectMapper mapper) {
        ArrayList fields = this.fields.stream().map(f -> f.serialize(mapper)).collect(Collectors.toCollection(() -> new ArrayList()));
        SerializedFilter filter = this.filter != null ? this.filter.serialize(mapper) : null;
        return new SerializedUpdate(this.model.getName(), fields, filter);
    }

    @Override
    public Void deserializeResult(ObjectMapper mapper, String data) throws Exception {
        return mapper.readValue(data, Void.class);
    }

    @Override
    public <C extends QueryContext> Void execute(DataModelMap<C> models, C ctx) throws Exception {
        DataController<T, C> impl = models.getController(this.model);
        impl.onUpdate(ctx, this.fields, this.filter);
        return null;
    }
}

