/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.SerializedOr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;

public class Or
implements Filter {
    private List<Filter> filters;

    public Or(Filter ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public Or(List<Filter> filters) {
        this.filters = List.copyOf(filters);
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public SerializedOr serialize(ObjectMapper mapper) {
        ArrayList filters = this.filters.stream().map(f -> f.serialize(mapper)).collect(Collectors.toCollection(() -> new ArrayList()));
        return new SerializedOr(filters);
    }

    @Override
    public Condition buildCondition(DSLContext dsl) {
        List conds = this.filters.stream().map(f -> f.buildCondition(dsl)).collect(Collectors.toList());
        return DSL.or(conds);
    }

    @Override
    public void getUniqueColumns(Set<DataColumn<?>> set) {
    }
}

