/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.query.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.query.filter.SerializedSpan;
import de.inahware.edvj.sql.SQLColumn;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;

public class Span<T>
implements Filter {
    private DataColumn<T> col;
    private T from;
    private boolean from_inclusive;
    private T until;
    private boolean until_inclusive;

    public Span(DataColumn<T> col, T from, T until) {
        this(col, from, true, until, false);
    }

    public Span(DataColumn<T> col, T from, boolean from_inclusive, T until, boolean until_inclusive) {
        this.col = col;
        this.from = from;
        this.from_inclusive = from_inclusive;
        this.until = until;
        this.until_inclusive = until_inclusive;
    }

    public T getFrom() {
        return this.from;
    }

    public boolean isFromInclusive() {
        return this.from_inclusive;
    }

    public T getUntil() {
        return this.until;
    }

    public boolean isUntilInclusive() {
        return this.until_inclusive;
    }

    @Override
    public SerializedSpan serialize(ObjectMapper mapper) {
        Object from = mapper.valueToTree(this.from);
        Object until = mapper.valueToTree(this.until);
        return new SerializedSpan(this.col.getName(), (JsonNode)from, this.from_inclusive, (JsonNode)until, this.until_inclusive);
    }

    @Override
    public void getUniqueColumns(Set<DataColumn<?>> set) {
    }

    @Override
    public Condition buildCondition(DSLContext dsl) {
        DataColumn<T> dataColumn = this.col;
        if (dataColumn instanceof SQLColumn) {
            SQLColumn sqlCol = (SQLColumn)dataColumn;
            Condition res = DSL.trueCondition();
            if (this.from != null) {
                res = this.from_inclusive ? res.and(sqlCol.getField().greaterOrEqual(this.from)) : res.and(sqlCol.getField().greaterThan(this.from));
            }
            if (this.until != null) {
                res = this.until_inclusive ? res.and(sqlCol.getField().lessOrEqual(this.until)) : res.and(sqlCol.getField().lessThan(this.until));
            }
            return res;
        }
        throw new UnsupportedOperationException();
    }
}

