/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.inahware.edvj.request.Request;
import de.inahware.edvj.request.RequestException;
import de.inahware.edvj.request.RequestResponse;
import de.inahware.edvj.request.RequestResponseType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHandler.class.getName());
    private ObjectMapper mapper;
    private Map<String, Class<? extends Request<C, ?>>> requests;

    public RequestHandler(ObjectMapper mapper) {
        this.mapper = mapper;
        this.requests = new HashMap();
    }

    public RequestHandler<C> with(Class<? extends Request<C, ?>> clazz) {
        this.insert(clazz);
        return this;
    }

    public void insert(Class<? extends Request<C, ?>> clazz) {
        String name = clazz.getCanonicalName();
        if (this.requests.containsKey(name)) {
            throw new IllegalArgumentException("request class inserted twice: " + name);
        }
        this.requests.put(name, clazz);
    }

    public RequestResponse execute(C ctx, String name, String data) throws JsonProcessingException {
        try {
            Request<C, ?> request;
            Class<? extends Request<C, ?>> clazz = this.requests.get(name);
            if (clazz == null) {
                throw new RequestException();
            }
            try {
                request = this.mapper.readValue(data, clazz);
            }
            catch (JsonProcessingException ex) {
                throw new RequestException();
            }
            Object res = request.execute(ctx);
            String json = this.mapper.writeValueAsString(res);
            return new RequestResponse(RequestResponseType.OK, json);
        }
        catch (RequestException ex) {
            LOGGER.debug("client error", ex);
            String json = this.mapper.writeValueAsString(ex.serialize());
            return new RequestResponse(RequestResponseType.CLIENT_ERROR, json);
        }
        catch (Exception ex) {
            LOGGER.error("server error", ex);
            RequestException ex2 = new RequestException("edvj.errors.server_error");
            String json = this.mapper.writeValueAsString(ex2.serialize());
            return new RequestResponse(RequestResponseType.SERVER_ERROR, json);
        }
    }
}

