/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.sql;

import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.inahware.edvj.sql.ArchiveReader;
import de.inahware.edvj.sql.ArchiveWriter;
import de.inahware.edvj.sql.Migration;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class MigrationManager {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(((JsonFactoryBuilder)((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().disable(StreamWriteFeature.AUTO_CLOSE_TARGET)).enable(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN)).disable(StreamReadFeature.AUTO_CLOSE_SOURCE)).build()).registerModule(new JavaTimeModule());
    private static final Field<Long> ID = DSL.field(DSL.name("id"), Long.class);
    private static final Field<Long> BATCH = DSL.field(DSL.name("batch"), Long.class);
    private static final Field<Timestamp> EXECUTED_AT = DSL.field(DSL.name("executed_at"), Timestamp.class);
    private final Table<Record> MIGRATION;
    private List<Migration> migrations;
    private List<Table<? extends Record>> tables;

    public MigrationManager() {
        this("migration");
    }

    public MigrationManager(String tableName) {
        this.MIGRATION = DSL.table(DSL.name(tableName));
        this.migrations = new ArrayList<Migration>();
        this.tables = new ArrayList<Table<? extends Record>>();
    }

    public Table<Record> getTable() {
        return this.MIGRATION;
    }

    public void add(Migration ... migrations) {
        for (Migration migration : migrations) {
            this.migrations.add(migration);
        }
    }

    public MigrationManager with(Migration ... migrations) {
        this.add(migrations);
        return this;
    }

    public List<Migration> getMigrations() {
        return this.migrations;
    }

    public void add(Table<?> ... tables) {
        for (Table<?> table : tables) {
            this.tables.add(table);
        }
    }

    public MigrationManager with(Table<?> ... tables) {
        this.add(tables);
        return this;
    }

    public List<Table<? extends Record>> getTables() {
        return this.tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(DSLContext dsl) throws Exception {
        String currentSchema = (String)((Record1)dsl.select(DSL.currentSchema()).fetchAny()).value1();
        try {
            this.disableChecks(dsl);
            for (Table<?> table : dsl.meta().getTables()) {
                if (!table.getSchema().getName().equals(currentSchema)) continue;
                dsl.dropTableIfExists(table).execute();
                dsl.dropViewIfExists(table).execute();
            }
        }
        finally {
            this.enableChecks(dsl);
        }
    }

    public void migrate(DSLContext dsl) {
        this.migrate(dsl, null);
    }

    public void migrate(DSLContext dsl, List<Long> state) {
        if (this.migrations.isEmpty()) {
            return;
        }
        String currentSchema = (String)((Record1)dsl.select(DSL.currentSchema()).fetchAny()).value1();
        if (dsl.meta().getTables(DSL.name(currentSchema, this.MIGRATION.getName())).isEmpty()) {
            dsl.createTable(this.MIGRATION).column(ID, SQLDataType.BIGINT.notNull()).column(BATCH, SQLDataType.BIGINT.notNull()).column(EXECUTED_AT, SQLDataType.TIMESTAMP).primaryKey(ID).execute();
        }
        Result<Record> res = dsl.fetch(dsl.selectFrom(this.MIGRATION));
        Set migrations_done = res.stream().map(r -> r.get(ID)).collect(Collectors.toSet());
        Long next_batch_id = res.stream().map(r -> r.get(BATCH)).max(Comparator.naturalOrder()).orElse(1L);
        HashSet<Long> state_set = state == null ? null : new HashSet<Long>(state);
        List migrations = this.migrations.stream().sorted(Comparator.comparing(m -> m.getId())).collect(Collectors.toList());
        for (Migration m2 : migrations) {
            long id = m2.getId();
            if (migrations_done.contains(id) || state_set != null && !state_set.contains(id)) continue;
            m2.run(dsl);
            dsl.insertInto(this.MIGRATION, ID, BATCH, EXECUTED_AT).values(id, next_batch_id, Timestamp.from(Instant.now())).execute();
        }
    }

    public List<Long> queryMigrations(DSLContext dsl) throws Exception {
        if (this.migrations.isEmpty()) {
            return List.of();
        }
        String db = (String)((Record1)dsl.select(DSL.currentSchema()).fetchAny()).value1();
        if (dsl.meta().getTables(DSL.name(db, this.MIGRATION.getName())).isEmpty()) {
            return List.of();
        }
        return dsl.selectFrom(this.MIGRATION).fetch().stream().map(r -> r.get(ID)).collect(Collectors.toList());
    }

    public void exportBackup(DSLContext dsl, ArchiveWriter writer) throws Exception {
        BackupInfo info = new BackupInfo();
        info.migrations = new ArrayList<Long>(this.queryMigrations(dsl));
        info.tables = this.tables.stream().map(t -> t.getName()).collect(Collectors.toCollection(() -> new ArrayList()));
        writer.next(".backup.json", output -> OBJECT_MAPPER.writeValue((OutputStream)output, (Object)info));
        dsl.transaction(config -> {
            DSLContext dsl2 = DSL.using(config);
            for (Table<? extends Record> table : this.tables) {
                writer.next(table.getName() + ".json.txt", output -> {
                    try (Cursor lazy = dsl2.selectFrom(table).fetchLazy();){
                        for (Record rec : lazy) {
                            ObjectNode node = OBJECT_MAPPER.createObjectNode();
                            for (Field<?> f : table.fields()) {
                                Object value = rec.get(f);
                                if (value instanceof JSON) {
                                    JSON json = (JSON)value;
                                    node.putPOJO(f.getName(), json.data());
                                    continue;
                                }
                                node.putPOJO(f.getName(), value);
                            }
                            OBJECT_MAPPER.writeValue((OutputStream)output, (Object)node);
                            output.write(new byte[]{10});
                        }
                    }
                });
            }
        });
    }

    public void importBackup(DSLContext dsl, ArchiveReader reader) throws Exception {
        BackupInfo info = reader.nextValue(".backup.json", input -> OBJECT_MAPPER.readValue((InputStream)input, BackupInfo.class));
        this.migrate(dsl, info.migrations);
        String currentSchema = (String)((Record1)dsl.select(DSL.currentSchema()).fetchAny()).value1();
        dsl.transaction(config -> {
            DSLContext dsl2 = DSL.using(config);
            this.disableChecks(dsl2);
            try {
                for (String tableName : info.tables) {
                    Table<?> table = dsl2.meta().getTables(DSL.name(currentSchema, tableName)).get(0);
                    reader.next(table.getName() + ".json.txt", input -> {
                        try (MappingIterator it = OBJECT_MAPPER.readerFor(ObjectNode.class).readValues((InputStream)input);){
                            while (it.hasNextValue()) {
                                ObjectNode node = (ObjectNode)it.nextValue();
                                HashMap map = new HashMap();
                                for (Field<?> f : table.fields()) {
                                    Object value;
                                    if (f.getDataType().isJSON()) {
                                        value = OBJECT_MAPPER.treeToValue((TreeNode)node.get(f.getName()), String.class);
                                        map.put(f, JSON.json((String)value));
                                        continue;
                                    }
                                    if (f.getDataType().isDate()) {
                                        value = OBJECT_MAPPER.treeToValue((TreeNode)node.get(f.getName()), LocalDate.class);
                                        map.put(f, value);
                                        continue;
                                    }
                                    if (f.getDataType().isDateTime()) {
                                        value = OBJECT_MAPPER.treeToValue((TreeNode)node.get(f.getName()), LocalDateTime.class);
                                        map.put(f, value);
                                        continue;
                                    }
                                    value = OBJECT_MAPPER.treeToValue((TreeNode)node.get(f.getName()), f.getType());
                                    map.put(f, value);
                                }
                                dsl2.insertInto(table).set(map).execute();
                            }
                        }
                    });
                }
            }
            finally {
                this.enableChecks(dsl2);
            }
        });
    }

    public void disableChecks(DSLContext dsl) throws Exception {
        switch (dsl.configuration().family()) {
            case MYSQL: 
            case MARIADB: {
                dsl.execute("SET FOREIGN_KEY_CHECKS = 0");
                break;
            }
            case SQLITE: {
                dsl.execute("PRAGMA foreign_keys = 0");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void enableChecks(DSLContext dsl) throws Exception {
        switch (dsl.configuration().family()) {
            case MYSQL: 
            case MARIADB: {
                dsl.execute("SET FOREIGN_KEY_CHECKS = 1");
                break;
            }
            case SQLITE: {
                dsl.execute("PRAGMA foreign_keys = 1");
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class BackupInfo {
        public Long version = 1L;
        public ArrayList<Long> migrations;
        public ArrayList<String> tables;

        BackupInfo() {
        }
    }
}

