/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.sql;

import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.Converter;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Record1;

public class SQLConvertColumn<T, U>
extends DataColumn<T> {
    private Field<U> field;

    public SQLConvertColumn(Class<T> clazz, Field<U> field, ColumnFlag ... flags) {
        super(clazz, field.getName().toUpperCase(), flags);
        this.field = field;
    }

    @Override
    public Field<U> getField() {
        return this.field;
    }

    @Override
    public DataField<T> fromRecord(Record record) {
        return this.with(record.get(this.field, this.getValueClass()));
    }

    @Override
    public Condition eq(DSLContext dsl, T value) {
        Converter conv = dsl.configuration().converterProvider().provide(this.field.getType(), this.getValueClass());
        return this.field.eq(conv.to(value));
    }

    @Override
    public Condition in(DSLContext dsl, Collection<T> values) {
        Converter conv = dsl.configuration().converterProvider().provide(this.field.getType(), this.getValueClass());
        return this.field.in(values.stream().map(v -> conv.to(v)).collect(Collectors.toList()));
    }

    @Override
    public Record1<U> set(DSLContext dsl, T value) {
        Converter conv = dsl.configuration().converterProvider().provide(this.field.getType(), this.getValueClass());
        return dsl.newRecord(this.field).with((Field)this.field, value, conv);
    }
}

