/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.sql;

import de.inahware.edvj.data.DataColumn;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.filter.Filter;
import de.inahware.edvj.sql.SQLViewDataController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.UpdatableRecord;

public abstract class SQLDataController<T extends DataObject, R extends UpdatableRecord<R>, C extends QueryContext>
extends SQLViewDataController<T, R, C> {
    protected final Set<DataColumn<?>> getUpdateColumns(List<DataField<?>> fields) {
        return fields.stream().map(f -> f.getColumn()).collect(Collectors.toCollection(() -> new HashSet()));
    }

    protected final Map<?, ?> getUpdateMap(DSLContext dsl, Set<DataColumn<?>> columns, T obj) {
        Table table = this.getTable();
        UpdatableRecord record = (UpdatableRecord)dsl.newRecord(table, obj);
        HashMap res = new HashMap();
        for (DataColumn<?> c : columns) {
            if (c.getField() == null) continue;
            res.put(c.getField(), record.get(c.getField()));
        }
        return res;
    }

    protected List<T> insertAll(C ctx, List<T> objs) throws Exception {
        DSLContext dsl = ctx.getDSLContext();
        return this.insertAll(dsl, objs);
    }

    protected List<T> insertAll(DSLContext dsl, List<T> objs) throws Exception {
        Table table = this.getTable();
        dsl.transaction(txconfig -> {
            for (DataObject obj : objs) {
                UpdatableRecord record = (UpdatableRecord)dsl.newRecord(table, obj);
                record.insert();
                record.into(obj);
            }
        });
        return objs;
    }

    protected void update(C ctx, List<DataField<?>> fields, Filter filter) throws Exception {
        DSLContext dsl = ctx.getDSLContext();
        Set<DataColumn<?>> columns = this.getUpdateColumns(fields);
        Object obj = this.getModel().createFromFields(fields);
        Condition cond = this.buildCondition(dsl, filter);
        this.update(dsl, columns, obj, cond);
    }

    protected void update(DSLContext dsl, List<DataField<?>> fields, Filter filter) throws Exception {
        Set<DataColumn<?>> columns = this.getUpdateColumns(fields);
        Object obj = this.getModel().createFromFields(fields);
        Condition cond = this.buildCondition(dsl, filter);
        this.update(dsl, columns, obj, cond);
    }

    protected void update(DSLContext dsl, List<DataField<?>> fields, Condition cond) throws Exception {
        Set<DataColumn<?>> columns = this.getUpdateColumns(fields);
        Object obj = this.getModel().createFromFields(fields);
        this.update(dsl, columns, obj, cond);
    }

    protected void update(DSLContext dsl, List<DataField<?>> fields, T obj, Filter filter) throws Exception {
        Set<DataColumn<?>> columns = this.getUpdateColumns(fields);
        Condition cond = this.buildCondition(dsl, filter);
        this.update(dsl, columns, obj, cond);
    }

    protected void update(DSLContext dsl, List<DataField<?>> fields, T obj, Condition cond) throws Exception {
        Set<DataColumn<?>> columns = this.getUpdateColumns(fields);
        this.update(dsl, columns, obj, cond);
    }

    protected void update(DSLContext dsl, Set<DataColumn<?>> columns, T obj, Filter filter) throws Exception {
        Condition cond = this.buildCondition(dsl, filter);
        this.update(dsl, columns, obj, cond);
    }

    protected final void update(DSLContext dsl, Set<DataColumn<?>> columns, T obj, Condition cond) throws Exception {
        Map<?, ?> map = this.getUpdateMap(dsl, columns, obj);
        this.update(dsl, map, cond);
    }

    protected final void update(DSLContext dsl, Map<?, ?> map, Condition cond) throws Exception {
        Table table = this.getTable();
        dsl.update(table).set(map).where(cond).execute();
    }

    protected void delete(C ctx, Filter filter) throws Exception {
        DSLContext dsl = ctx.getDSLContext();
        Condition cond = this.buildCondition(dsl, filter);
        this.delete(dsl, cond);
    }

    protected final void delete(DSLContext dsl, Filter filter) throws Exception {
        Condition cond = this.buildCondition(dsl, filter);
        this.delete(dsl, cond);
    }

    protected final void delete(DSLContext dsl, Condition cond) throws Exception {
        Table table = this.getTable();
        dsl.deleteFrom(table).where(cond).execute();
    }
}

