/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.edvj.sql;

import de.inahware.edvj.data.model.DataController;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.query.QueryContext;
import de.inahware.edvj.query.filter.Filter;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectLimitAfterOffsetStep;
import org.jooq.Table;
import org.jooq.impl.DSL;

public abstract class SQLViewDataController<T extends DataObject, R extends Record, C extends QueryContext>
extends DataController<T, C> {
    protected final Condition buildCondition(DSLContext dsl, Filter filter) {
        return filter != null ? filter.buildCondition(dsl) : DSL.trueCondition();
    }

    protected List<T> selectAll(C ctx, Filter filter, int offset, int limit) throws Exception {
        DSLContext dsl = ctx.getDSLContext();
        Condition cond = this.buildCondition(dsl, filter);
        return this.fetchObjects(dsl, cond, offset, limit);
    }

    protected List<T> selectAll(DSLContext dsl, Filter filter, int offset, int limit) throws Exception {
        Condition cond = this.buildCondition(dsl, filter);
        return this.fetchObjects(dsl, cond, offset, limit);
    }

    protected final List<T> fetchObjects(DSLContext dsl, Condition cond, int offset, int limit) throws Exception {
        return this.fetchRecords(dsl, cond, offset, limit).into(this.getModel().getObjectClass());
    }

    protected final Result<R> fetchRecords(DSLContext dsl, Condition cond, int offset, int limit) throws Exception {
        return this.selectRecords(dsl, cond, offset, limit).fetch();
    }

    protected final Cursor<R> selectRecords(DSLContext dsl, Condition cond, int offset, int limit) throws Exception {
        Table<R> table = this.getTable();
        SelectLimitAfterOffsetStep q = dsl.selectFrom(table).where(cond).offset(offset);
        if (limit < 0) {
            return q.fetchLazy();
        }
        return q.limit(limit).fetchLazy();
    }

    public abstract Table<R> getTable();
}

