/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.products;

import de.inahware.products.ProductInfo;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.json.JSONObject;

public class ActivatedProduct {
    private ProductInfo product;
    private String productKey;
    private String licenseKey;

    ActivatedProduct(ProductInfo version, String productKey, String licenseKey) {
        this.product = version;
        this.productKey = productKey;
        this.licenseKey = licenseKey;
    }

    public ProductInfo getProduct() {
        return this.product;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public URI getApiURI() throws Exception {
        return this.product.getApiURI();
    }

    public URI getApiURI(String path) throws Exception {
        return this.product.getApiURI(path);
    }

    public URI getApiProjectURI() throws Exception {
        return this.product.getApiProjectURI();
    }

    public URI getDownloadURI(String path) throws Exception {
        if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return new URI(this.product.getRepoUrl() + "project/" + this.product.getVersion().getName() + "/" + this.product.getVersion().getVersion() + (String)path + (String)(this.licenseKey != null ? "?license=" + this.licenseKey : ""));
    }

    public URI getUpdateDownloadURI(String path) throws Exception {
        if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return new URI(this.product.getRepoUrl() + "project/" + this.product.getVersion().getName() + "/current" + (String)path + (String)(this.licenseKey != null ? "?license=" + this.licenseKey : ""));
    }

    public String fetchUpdate() throws Exception {
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        return this.fetchUpdate(client);
    }

    public String fetchUpdate(HttpClient client) throws Exception {
        HttpRequest req;
        HttpResponse<String> res;
        HttpRequest.Builder builder = HttpRequest.newBuilder(this.getApiProjectURI());
        if (this.licenseKey != null) {
            builder.header("Authorization", "Bearer " + this.licenseKey);
        }
        if ((res = client.send(req = builder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() != 200) {
            return null;
        }
        JSONObject obj = new JSONObject(res.body());
        JSONObject current_version = obj.getJSONObject("current_version");
        String version2 = current_version.getString("version");
        return version2;
    }
}

