/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.products;

import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import de.inahware.products.ActivatedProduct;
import de.inahware.products.ProductInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;
import net.miginfocom.swing.MigLayout;

public class ActivationDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private ResourceBundle BUNDLE = I18N.getBundle();
    private JPanel panel;
    private JLabel lblNewLabel;
    private JFormattedTextField formattedTextField;
    private JPanel panel_1;
    private JButton btnOk;
    private JButton btnCancel;

    public ActivationDialog(ProductInfo info, CompletableFuture<ActivatedProduct> future) {
        this.setTitle("product activation");
        this.setPacking(true);
        this.initialize();
        this.setDefaultButton(this.btnOk);
        this.btnOk.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            ActivatedProduct activated = info.verifyKey(this.formattedTextField.getText());
            future.complete(activated);
            this.close();
        }));
        this.btnCancel.addActionListener(ev -> this.close());
        this.addClosedListener(() -> future.complete(null));
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new MigLayout("", "[240px,grow]", "[][]"));
        this.lblNewLabel = new JLabel("enter product key");
        this.panel.add((Component)this.lblNewLabel, "cell 0 0");
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("U-HHHHHH-HHHHHH-HHHHHH-HHHHHH");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.formattedTextField = new JFormattedTextField(formatter);
        this.formattedTextField.setFont(new Font("Monospaced", 0, 12));
        this.formattedTextField.setFocusLostBehavior(3);
        this.panel.add((Component)this.formattedTextField, "cell 0 1,growx");
        this.panel_1 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_1.getLayout();
        flowLayout.setAlignment(2);
        this.add((Component)this.panel_1, "South");
        this.btnOk = new JButton(this.BUNDLE.getString("edvj.generic.button.ok"));
        this.panel_1.add(this.btnOk);
        this.btnCancel = new JButton(this.BUNDLE.getString("edvj.generic.button.cancel"));
        this.panel_1.add(this.btnCancel);
    }
}

