/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.products;

import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.gui.EUtils;
import de.inahware.products.ActivatedProduct;
import de.inahware.products.ActivationDialog;
import de.inahware.products.ActivationException;
import de.inahware.products.ProductId;
import de.inahware.products.ProductKeyException;
import de.inahware.products.ProductKeyUtils;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.json.JSONObject;

public class ProductInfo {
    private VersionInfo version;
    private String repoUrl;
    private ProductId productId;

    public ProductInfo(VersionInfo version) {
        this(version, null);
    }

    public ProductInfo(VersionInfo version, String repo_url) {
        this(version, repo_url, null);
    }

    public ProductInfo(VersionInfo version, String repoUrl, ProductId productId) {
        this.version = version;
        this.repoUrl = repoUrl;
        this.productId = productId;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public ProductId getProductId() {
        return this.productId;
    }

    public URI getApiURI() throws Exception {
        return this.getApiURI("");
    }

    public URI getApiURI(String path) throws Exception {
        if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return new URI(this.repoUrl + "api/project/" + this.version.getName() + "/" + this.version.getVersion() + (String)path);
    }

    public URI getApiProjectURI() throws Exception {
        return this.getApiProjectURI("");
    }

    public URI getApiProjectURI(String path) throws Exception {
        if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return new URI(this.repoUrl + "api/project/" + this.version.getName() + (String)path);
    }

    public ActivatedProduct activate(String filename, Class<?> cls, Path ... localPaths) throws Exception {
        Path path = this.getKeyFilePath(filename, cls, localPaths);
        ActivatedProduct activated = this.tryActivate(path);
        if (activated != null) {
            return activated;
        }
        throw new ActivationException();
    }

    public ActivatedProduct activateKey(String key, String filename, Class<?> cls, Path ... localPaths) throws Exception {
        ActivatedProduct activated = this.verifyKey(key);
        try {
            Path path = this.getKeyFilePath(filename, cls, localPaths);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.writeString(path, (CharSequence)"", new OpenOption[0]);
            }
            if (activated.getLicenseKey() != null) {
                Files.writeString(path, (CharSequence)("L" + activated.getLicenseKey() + "\n"), StandardOpenOption.APPEND);
            }
            if (activated.getProductKey() != null) {
                Files.writeString(path, (CharSequence)("P" + activated.getProductKey() + "\n"), StandardOpenOption.APPEND);
            }
        }
        catch (IOException ex) {
            throw new ActivationException();
        }
        return activated;
    }

    public ActivatedProduct activateWindow(String filename, Class<?> cls, Path ... localPaths) throws Exception {
        Path path = this.getKeyFilePath(filename, cls, localPaths);
        ActivatedProduct activated = this.tryActivate(path);
        if (activated != null) {
            return activated;
        }
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.writeString(path, (CharSequence)"", new OpenOption[0]);
            }
            CompletableFuture future = new CompletableFuture();
            SwingUtilities.invokeLater(() -> new ActivationDialog(this, future).intoWindow().setVisible(true));
            activated = (ActivatedProduct)future.get();
            if (activated == null) {
                throw new ActivationException();
            }
            if (activated.getLicenseKey() != null) {
                Files.writeString(path, (CharSequence)("L" + activated.getLicenseKey() + "\n"), StandardOpenOption.APPEND);
            }
            if (activated.getProductKey() != null) {
                Files.writeString(path, (CharSequence)("P" + activated.getProductKey() + "\n"), StandardOpenOption.APPEND);
            }
            return activated;
        }
        catch (IOException ex) {
            throw new ActivationException();
        }
    }

    public ActivatedProduct activateDialog(Window parent, String filename, Class<?> cls, Path ... localPaths) throws Exception {
        Path path = this.getKeyFilePath(filename, cls, localPaths);
        ActivatedProduct activated = this.tryActivate(path);
        if (activated != null) {
            return activated;
        }
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.writeString(path, (CharSequence)"", new OpenOption[0]);
            }
            CompletableFuture<ActivatedProduct> future = new CompletableFuture<ActivatedProduct>();
            new ActivationDialog(this, future).intoModalDialog(parent).setVisible(true);
            activated = future.get();
            if (activated == null) {
                throw new ActivationException();
            }
            if (activated.getLicenseKey() != null) {
                Files.writeString(path, (CharSequence)("L" + activated.getLicenseKey() + "\n"), StandardOpenOption.APPEND);
            }
            if (activated.getProductKey() != null) {
                Files.writeString(path, (CharSequence)("P" + activated.getProductKey() + "\n"), StandardOpenOption.APPEND);
            }
            return activated;
        }
        catch (IOException ex) {
            throw new ActivationException();
        }
    }

    private Path getKeyFilePath(String filename, Class<?> cls, Path ... localPaths) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (cls != null) {
            Path execPath = Path.of(cls.getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath();
            if (!execPath.toFile().isDirectory()) {
                execPath = execPath.getParent();
            }
            paths.add(execPath.resolve(filename));
        }
        for (Path p2 : localPaths) {
            paths.add(p2.resolve(filename));
        }
        return paths.stream().filter(p -> Files.exists(p, new LinkOption[0])).findAny().orElse((Path)paths.get(0));
    }

    private ActivatedProduct tryActivate(Path path) throws Exception {
        if (this.productId == null) {
            return new ActivatedProduct(this, null, null);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        String licenseKey = null;
        ArrayList<String> productKeys = new ArrayList<String>();
        List<String> lines = Files.readAllLines(path);
        for (String line : lines) {
            if (line.startsWith("L")) {
                licenseKey = line.substring(1);
                continue;
            }
            if (!line.startsWith("P")) continue;
            productKeys.add(line.substring(1));
        }
        for (String key : productKeys) {
            try {
                return this.verifyProductKey(key, licenseKey);
            }
            catch (ProductKeyException productKeyException) {
            }
        }
        if (licenseKey != null) {
            ActivatedProduct activated = this.verifyLicenseKey(licenseKey);
            EUtils.catchSilently(() -> {
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.writeString(path, (CharSequence)"", new OpenOption[0]);
                }
                Files.writeString(path, (CharSequence)("P" + activated.getProductKey() + "\n"), StandardOpenOption.APPEND);
            });
            return activated;
        }
        return null;
    }

    public ActivatedProduct verifyKey(String key) throws ActivationException {
        if ((key = Stream.of(key.split("-")).collect(Collectors.joining())).startsWith("L")) {
            return this.verifyLicenseKey(key.substring(1));
        }
        if (key.startsWith("P")) {
            return this.verifyProductKey(key.substring(1));
        }
        throw new ActivationException();
    }

    public ActivatedProduct verifyLicenseKey(String licenseKey) throws ActivationException {
        try {
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest req = HttpRequest.newBuilder(this.getApiURI()).header("Authorization", "Bearer " + licenseKey).build();
            HttpResponse<String> res = httpClient.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                throw new ActivationException();
            }
            JSONObject obj = new JSONObject(res.body());
            String key = obj.getString("product_key");
            return this.verifyProductKey(key, licenseKey);
        }
        catch (Exception ex) {
            throw new ActivationException();
        }
    }

    public ActivatedProduct verifyProductKey(String productKey) throws ProductKeyException {
        return this.verifyProductKey(productKey, null);
    }

    public ActivatedProduct verifyProductKey(String productKey, String licenseKey) throws ProductKeyException {
        long id = ProductKeyUtils.keyToId(productKey, this.productId.getLength());
        if (id != this.productId.getId()) {
            throw new ProductKeyException();
        }
        return new ActivatedProduct(this, productKey, licenseKey);
    }
}

