/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.products;

import de.inahware.products.ProductKeyException;
import java.util.Arrays;

public class ProductKeyUtils {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] H0 = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};

    public static long keyToId(String input, int idLen) throws ProductKeyException {
        if (input.length() % 8 != 0) {
            throw new ProductKeyException();
        }
        try {
            int[] key = new int[input.length() / 8];
            for (int i = 0; i < input.length() / 8; ++i) {
                key[i] = (int)Long.parseLong(input.substring(i * 8, i * 8 + 8), 16);
            }
            return ProductKeyUtils.keyToId(key, idLen);
        }
        catch (NumberFormatException ex) {
            throw new ProductKeyException();
        }
    }

    public static long keyToId(int[] key, int idLen) {
        int[] words = Arrays.copyOf(key, 64);
        words[key.length] = Integer.MIN_VALUE;
        words[15] = key.length * 32;
        for (int t = 16; t < words.length; ++t) {
            int t0 = Integer.rotateRight(words[t - 2], 17) ^ Integer.rotateRight(words[t - 2], 19) ^ words[t - 2] >>> 10;
            int t1 = Integer.rotateRight(words[t - 15], 7) ^ Integer.rotateRight(words[t - 15], 18) ^ words[t - 15] >>> 3;
            words[t] = t0 + words[t - 7] + t1 + words[t - 16];
        }
        int[] TEMP = (int[])H0.clone();
        for (int i = 0; i < words.length; ++i) {
            int t0 = Integer.rotateRight(TEMP[4], 6) ^ Integer.rotateRight(TEMP[4], 11) ^ Integer.rotateRight(TEMP[4], 25);
            int t1 = TEMP[4] & TEMP[5] | ~TEMP[4] & TEMP[6];
            int t2 = TEMP[7] + t0 + t1 + K[i] + words[i];
            int t3 = Integer.rotateRight(TEMP[0], 2) ^ Integer.rotateRight(TEMP[0], 13) ^ Integer.rotateRight(TEMP[0], 22);
            int t4 = t3 + (TEMP[0] & TEMP[1] | TEMP[0] & TEMP[2] | TEMP[1] & TEMP[2]);
            System.arraycopy(TEMP, 0, TEMP, 1, TEMP.length - 1);
            TEMP[4] = TEMP[4] + t2;
            TEMP[0] = t2 + t4;
        }
        int[] H = (int[])H0.clone();
        for (int t = 0; t < H.length; ++t) {
            int n = t;
            H[n] = H[n] + TEMP[t];
        }
        long id = (long)(H[0] ^ H[2] ^ H[4] ^ H[6]) << 32 | (long)(H[1] ^ H[3] ^ H[5] ^ H[7]);
        return id << 64 - idLen >>> 64 - idLen;
    }
}

