/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.AggregateFunction;
import org.jooq.BindContext;
import org.jooq.Binding;
import org.jooq.Catalog;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Internal;
import org.jooq.Name;
import org.jooq.Package;
import org.jooq.Parameter;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Results;
import org.jooq.Routine;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.conf.SettingsTools;
import org.jooq.conf.ThrowExceptions;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.Cast;
import org.jooq.impl.CommentImpl;
import org.jooq.impl.Convert;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultAggregateFunction;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.DefaultBindingGetStatementContext;
import org.jooq.impl.DefaultBindingRegisterContext;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.Function;
import org.jooq.impl.QOM;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

@Internal
public abstract class AbstractRoutine<T>
extends AbstractNamed
implements Routine<T>,
QOM.UNotYetImplemented {
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_FUNCTION};
    private static final Set<SQLDialect> REQUIRE_SELECT_FROM = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> REQUIRE_DISAMBIGUATE_OVERLOADS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final Schema schema;
    private final List<Parameter<?>> allParameters;
    private final List<Parameter<?>> inParameters;
    private final List<Parameter<?>> outParameters;
    private final DataType<T> type;
    private Parameter<T> returnParameter;
    private ResultsImpl results;
    private Boolean isSQLUsable;
    private boolean overloaded;
    private boolean hasUnnamedParameters;
    private final Map<Parameter<?>, Field<?>> inValues;
    private final Set<Parameter<?>> inValuesDefaulted;
    private final Set<Parameter<?>> inValuesNonDefaulted;
    private transient Field<T> function;
    private Configuration configuration;
    private final Map<Parameter<?>, Object> outValues;
    private final Map<Parameter<?>, Integer> resultIndexes = new HashMap();

    protected AbstractRoutine(String name, Schema schema) {
        this(name, schema, null, null, null, null);
    }

    protected AbstractRoutine(String name, Schema schema, Package pkg) {
        this(name, schema, pkg, null, null, null);
    }

    protected AbstractRoutine(String name, Schema schema, DataType<T> type) {
        this(name, schema, null, type, null, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, DataType<X> type, Converter<X, T> converter) {
        this(name, schema, null, type, converter, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, DataType<X> type, Binding<X, T> binding) {
        this(name, schema, null, type, null, binding);
    }

    protected <X, Y> AbstractRoutine(String name, Schema schema, DataType<X> type, Converter<Y, T> converter, Binding<X, Y> binding) {
        this(name, schema, null, type, converter, binding);
    }

    protected AbstractRoutine(String name, Schema schema, Package pkg, DataType<T> type) {
        this(name, schema, pkg, type, null, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, Package pkg, DataType<X> type, Converter<X, T> converter) {
        this(name, schema, pkg, type, converter, null);
    }

    protected <X> AbstractRoutine(String name, Schema schema, Package pkg, DataType<X> type, Binding<X, T> binding) {
        this(name, schema, pkg, type, null, binding);
    }

    protected <X, Y> AbstractRoutine(String name, Schema schema, Package pkg, DataType<X> type, Converter<Y, T> converter, Binding<X, Y> binding) {
        super(AbstractRoutine.qualify(pkg != null ? pkg : schema, DSL.name(name)), CommentImpl.NO_COMMENT);
        this.schema = schema;
        this.allParameters = new ArrayList();
        this.inParameters = new ArrayList();
        this.outParameters = new ArrayList();
        this.results = new ResultsImpl(null);
        this.inValues = new HashMap();
        this.inValuesDefaulted = new HashSet();
        this.inValuesNonDefaulted = new HashSet();
        this.outValues = new HashMap();
        this.type = converter == null && binding == null ? type : type.asConvertedDataType(DefaultBinding.newBinding(converter, type, binding));
    }

    protected final <N extends Number> void setNumber(Parameter<N> parameter, Number value) {
        this.setValue(parameter, (Number)Convert.convert((Object)value, parameter.getType()));
    }

    protected final void setNumber(Parameter<? extends Number> parameter, Field<? extends Number> value) {
        this.setField(parameter, value);
    }

    @Override
    public final <Z> void setValue(Parameter<Z> parameter, Z value) {
        this.set(parameter, value);
    }

    @Override
    public final <Z> void set(Parameter<Z> parameter, Z value) {
        this.setField(parameter, DSL.val(value, parameter.getDataType()));
    }

    protected final void setField(Parameter<?> parameter, Field<?> value) {
        if (value == null) {
            this.setField(parameter, DSL.val(null, parameter.getDataType()));
        } else {
            this.inValues.put(parameter, value);
            this.inValuesDefaulted.remove(parameter);
            this.inValuesNonDefaulted.add(parameter);
        }
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final int execute(Configuration c) {
        return Tools.attach(this, c, this::execute);
    }

    @Override
    public final int execute() {
        Configuration config = Tools.configurationOrThrow(this);
        SQLDialect family = config.family();
        this.results.clear();
        this.outValues.clear();
        if (this.isSQLUsable() && REQUIRE_SELECT_FROM.contains((Object)config.dialect())) {
            return this.executeSelectFromPOSTGRES();
        }
        if (this.type == null) {
            return this.executeCallableStatement();
        }
        switch (family) {
            case HSQLDB: {
                if (SQLDataType.RESULT.equals(this.type.getSQLDataType())) {
                    return this.executeSelectFromHSQLDB();
                }
            }
            case FIREBIRD: 
            case H2: {
                return this.executeSelect();
            }
        }
        return this.executeCallableStatement();
    }

    private final int executeSelectFromHSQLDB() {
        DSLContext create = this.create(this.configuration);
        Result result = create.selectFrom(DSL.table(this.asField())).fetch();
        this.outValues.put(this.returnParameter, result);
        return 0;
    }

    private final int executeSelectFromPOSTGRES() {
        DSLContext create = this.create(this.configuration);
        ArrayList fields = new ArrayList(1 + this.outParameters.size());
        if (this.returnParameter != null) {
            fields.add(DSL.field(DSL.name(this.getName()), this.returnParameter.getDataType()));
        }
        for (Parameter<?> p : this.outParameters) {
            fields.add(DSL.field(DSL.name(p.getName()), p.getDataType()));
        }
        Result result = fields.size() == 1 && ((Field)fields.get(0)).getDataType().isUDT() ? create.select(DSL.field("row(t.*)", ((Field)fields.get(0)).getDataType())).from("{0} as t", this.asField()).fetch() : create.select(fields).from("{0}", this.asField()).fetch();
        int i = 0;
        if (this.returnParameter != null) {
            this.outValues.put(this.returnParameter, this.returnParameter.getDataType().convert(result.getValue(0, i++)));
        }
        for (Parameter<?> p : this.outParameters) {
            this.outValues.put(p, p.getDataType().convert(result.getValue(0, i++)));
        }
        return 0;
    }

    private final int executeSelect() {
        Field<T> field = this.asField();
        this.outValues.put(this.returnParameter, this.create(this.configuration).select(field).fetchOne(field));
        return 0;
    }

    private final int executeCallableStatement() {
        DefaultExecuteContext ctx = new DefaultExecuteContext(this.configuration, this);
        ExecuteListener listener = ExecuteListeners.get(ctx);
        try {
            listener.start(ctx);
            Connection connection = ctx.connection();
            listener.renderStart(ctx);
            ctx.sql(this.create(this.configuration).render(this));
            listener.renderEnd(ctx);
            listener.prepareStart(ctx);
            if (ctx.statement() == null) {
                ctx.statement(connection.prepareCall(ctx.sql()));
            }
            Tools.setFetchSize(ctx, 0);
            listener.prepareEnd(ctx);
            int t = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t != 0) {
                ctx.statement().setQueryTimeout(t);
            }
            listener.bindStart(ctx);
            DSL.using(this.configuration).bindContext(ctx.statement()).visit(this);
            this.registerOutParameters(ctx);
            listener.bindEnd(ctx);
            SQLException e = this.execute0(ctx, listener);
            if (ctx.family() != SQLDialect.FIREBIRD) {
                Tools.consumeResultSets(ctx, listener, this.results, null, e);
            }
            listener.outStart(ctx);
            this.fetchOutParameters(ctx);
            listener.outEnd(ctx);
            int n = 0;
            return n;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }

    private final SQLException execute0(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        SQLException e = Tools.executeStatementAndGetFirstResultSet(ctx, 0);
        listener.executeEnd(ctx);
        if (e != null) {
            this.results.resultsOrRows().add(new ResultsImpl.ResultOrRowsImpl(Tools.translate(ctx.sql(), e)));
        }
        return e;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void bind0(BindContext context) {
        List<Parameter<?>> all = this.getParameters0(context.configuration());
        List<Parameter<?>> in = this.getInParameters0(context.configuration());
        for (Parameter<?> parameter : all) {
            if (in.contains(parameter) && this.inValuesDefaulted.contains(parameter)) continue;
            this.bind1(context, parameter, this.getInValues().get(parameter) != null, this.resultParameter(context.configuration(), parameter));
        }
    }

    private final void bind1(BindContext context, Parameter<?> parameter, boolean bindAsIn, boolean bindAsOut) {
        int index = context.peekIndex();
        if (bindAsOut) {
            this.resultIndexes.put(parameter, index);
        }
        if (bindAsIn) {
            context.visit(this.getInValues().get(parameter));
            if (index == context.peekIndex() && bindAsOut) {
                context.nextIndex();
            }
        } else {
            context.nextIndex();
        }
    }

    final void toSQL0(RenderContext context) {
        this.toSQLDeclare(context);
        this.toSQLBegin(context);
        if (this.getReturnParameter0(context.configuration()) != null) {
            this.toSQLAssign(context);
        }
        this.toSQLCall(context);
        context.sql(" (");
        String separator = "";
        List<Parameter<?>> all = this.getParameters0(context.configuration());
        boolean defaulted = false;
        LinkedHashMap indexes = new LinkedHashMap();
        for (int i = 0; i < all.size(); ++i) {
            Parameter<?> parameter = all.get(i);
            if (parameter.equals(this.getReturnParameter0(context.configuration())) || this.inValuesDefaulted.contains(parameter) && (defaulted |= true)) continue;
            indexes.put(i, parameter);
        }
        boolean indent = false;
        if (indent) {
            ((RenderContext)context.formatIndentStart()).formatNewLine();
        }
        int i = 0;
        for (Map.Entry entry : indexes.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            int index = (Integer)entry.getKey();
            context.sql(separator);
            if (indent && i++ > 0) {
                context.formatNewLine();
            }
            if (defaulted && context.family() == SQLDialect.POSTGRES) {
                ((RenderContext)context.visit(parameter.getUnqualifiedName())).sql(" := ");
            }
            if (this.getOutParameters0(context.configuration()).contains(parameter)) {
                this.toSQLOutParam(context, parameter, index);
            } else {
                this.toSQLInParam(context, parameter, index, this.getInValues().get(parameter));
            }
            separator = ", ";
        }
        if (indent) {
            ((RenderContext)context.formatIndentEnd()).formatNewLine();
        }
        context.sql(')');
        this.toSQLEnd(context);
    }

    private final void toSQLEnd(RenderContext context) {
        if (this.isSQLUsable() || context.family() != SQLDialect.POSTGRES) {
            context.sql(" }");
        }
    }

    private final void toSQLDeclare(RenderContext context) {
    }

    private final void toSQLBegin(RenderContext context) {
        if (this.isSQLUsable() || context.family() != SQLDialect.POSTGRES) {
            context.sql("{ ");
        }
    }

    private final void toSQLAssign(RenderContext context) {
        context.sql("? = ");
    }

    private final void toSQLCall(RenderContext context) {
        context.sql("call ");
        context.visit(this.getQualifiedName(context));
    }

    private final void toSQLOutParam(RenderContext ctx, Parameter<?> parameter, int index) {
        ctx.sql('?');
    }

    private final void toSQLInParam(RenderContext ctx, Parameter<?> parameter, int index, Field<?> value) {
        ctx.visit(value);
    }

    private final Name getQualifiedName(Context<?> ctx) {
        Schema mapped;
        ArrayList<Name> list = new ArrayList<Name>();
        if (ctx.qualify() && (mapped = Tools.getMappedSchema(ctx, this.getSchema())) != null && !"".equals(mapped.getName())) {
            list.addAll(Arrays.asList(mapped.getQualifiedName().parts()));
        }
        list.add(this.getUnqualifiedName());
        return DSL.name(list.toArray(Tools.EMPTY_NAME));
    }

    private final void fetchOutParameters(ExecuteContext ctx) throws SQLException {
        for (Parameter<?> parameter : this.getParameters0(ctx.configuration())) {
            if (!this.resultParameter(ctx.configuration(), parameter)) continue;
            try {
                this.fetchOutParameter(ctx, parameter);
            }
            catch (SQLException e) {
                if (ctx.settings().getThrowExceptions() == ThrowExceptions.THROW_NONE) continue;
                throw e;
            }
        }
    }

    private final <U> void fetchOutParameter(ExecuteContext ctx, Parameter<U> parameter) throws SQLException {
        DefaultBindingGetStatementContext out = new DefaultBindingGetStatementContext(ctx, (CallableStatement)ctx.statement(), this.resultIndexes.get(parameter));
        parameter.getBinding().get(out);
        this.outValues.put(parameter, out.value());
    }

    private final void registerOutParameters(ExecuteContext ctx) throws SQLException {
        Configuration c = ctx.configuration();
        CallableStatement statement = (CallableStatement)ctx.statement();
        for (Parameter<?> parameter : this.getParameters0(ctx.configuration())) {
            if (!this.resultParameter(c, parameter)) continue;
            this.registerOutParameter(ctx, statement, parameter);
        }
    }

    private final <U> void registerOutParameter(ExecuteContext ctx, CallableStatement statement, Parameter<U> parameter) throws SQLException {
        parameter.getBinding().register(new DefaultBindingRegisterContext(ctx, statement, this.resultIndexes.get(parameter)));
    }

    @Override
    public final T getReturnValue() {
        if (this.returnParameter != null) {
            return this.getValue(this.returnParameter);
        }
        return null;
    }

    @Override
    public final Results getResults() {
        return this.results;
    }

    @Override
    public final <Z> Z getValue(Parameter<Z> parameter) {
        return this.get(parameter);
    }

    @Override
    public final <Z> Z get(Parameter<Z> parameter) {
        return (Z)this.outValues.get(parameter);
    }

    @Override
    public final <Z> Z getInValue(Parameter<Z> parameter) {
        return (Z)this.inValues.get(parameter);
    }

    protected final Map<Parameter<?>, Field<?>> getInValues() {
        return this.inValues;
    }

    @Override
    public final List<Parameter<?>> getOutParameters() {
        return Collections.unmodifiableList(this.outParameters);
    }

    @Override
    public final List<Parameter<?>> getInParameters() {
        return Collections.unmodifiableList(this.inParameters);
    }

    @Override
    public final List<Parameter<?>> getParameters() {
        return Collections.unmodifiableList(this.allParameters);
    }

    private final List<Parameter<?>> getOutParameters0(Configuration c) {
        return this.getOutParameters();
    }

    private final List<Parameter<?>> getInParameters0(Configuration c) {
        return this.getInParameters();
    }

    private final List<Parameter<?>> getParameters0(Configuration c) {
        return this.getParameters();
    }

    @Override
    public final Catalog getCatalog() {
        return this.getSchema() == null ? null : this.getSchema().getCatalog();
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final Parameter<T> getReturnParameter() {
        return this.returnParameter;
    }

    private final Parameter<T> getReturnParameter0(Configuration c) {
        return this.getReturnParameter();
    }

    protected final void setOverloaded(boolean overloaded) {
        this.overloaded = overloaded;
    }

    protected final boolean isOverloaded() {
        return this.overloaded;
    }

    protected final void setSQLUsable(boolean isSQLUsable) {
        this.isSQLUsable = isSQLUsable;
    }

    protected final boolean isSQLUsable() {
        return !Boolean.FALSE.equals(this.isSQLUsable);
    }

    private final boolean pgArgNeedsCasting(Parameter<?> parameter) {
        return this.isOverloaded() || parameter.getType() == Byte.class || parameter.getType() == Short.class;
    }

    private final boolean hasUnnamedParameters() {
        return this.hasUnnamedParameters;
    }

    private final void addParameter(Parameter<?> parameter) {
        this.allParameters.add(parameter);
        this.hasUnnamedParameters |= parameter.isUnnamed();
    }

    private final boolean resultParameter(Configuration c, Parameter<?> parameter) {
        return parameter.equals(this.getReturnParameter0(c)) || this.getOutParameters0(c).contains(parameter);
    }

    protected final void addInParameter(Parameter<?> parameter) {
        this.addParameter(parameter);
        this.inParameters.add(parameter);
        this.inValues.put(parameter, DSL.val(null, parameter.getDataType()));
        if (parameter.isDefaulted()) {
            this.inValuesDefaulted.add(parameter);
        } else {
            this.inValuesNonDefaulted.add(parameter);
        }
    }

    protected final void addInOutParameter(Parameter<?> parameter) {
        this.addInParameter(parameter);
        this.outParameters.add(parameter);
    }

    protected final void addOutParameter(Parameter<?> parameter) {
        this.addParameter(parameter);
        this.outParameters.add(parameter);
    }

    protected final void setReturnParameter(Parameter<T> parameter) {
        this.addParameter(parameter);
        this.returnParameter = parameter;
    }

    public final Field<T> asField() {
        if (this.function == null) {
            this.function = new RoutineField();
        }
        return this.function;
    }

    public final Field<T> asField(String alias) {
        return this.asField().as(alias);
    }

    public final AggregateFunction<T> asAggregateFunction() {
        Field[] array = new Field[this.getInParameters().size()];
        int i = 0;
        for (Parameter<?> p : this.getInParameters()) {
            array[i] = this.getInValues().get(p);
            ++i;
        }
        return new DefaultAggregateFunction<T>(false, this.getQualifiedName(), this.type, array);
    }

    @Deprecated
    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type) {
        return AbstractRoutine.createParameter(name, type, false, null, null);
    }

    @Deprecated
    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, null, null);
    }

    @Deprecated
    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, Converter<T, U> converter) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, converter, null);
    }

    @Deprecated
    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, Binding<T, U> binding) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, null, binding);
    }

    @Deprecated
    protected static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, Converter<X, U> converter, Binding<T, X> binding) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, false, converter, binding);
    }

    @Deprecated
    protected static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, isUnnamed, null, null);
    }

    @Deprecated
    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<T, U> converter) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, isUnnamed, converter, null);
    }

    @Deprecated
    protected static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Binding<T, U> binding) {
        return AbstractRoutine.createParameter(name, type, isDefaulted, isUnnamed, null, binding);
    }

    @Deprecated
    protected static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<X, U> converter, Binding<T, X> binding) {
        return org.jooq.impl.Internal.createParameter(name, type, isDefaulted, isUnnamed, converter, binding);
    }

    @Override
    public final Schema $schema() {
        return this.schema;
    }

    private class RoutineField
    extends AbstractField<T>
    implements QOM.UNotYetImplemented {
        RoutineField() {
            super(AbstractRoutine.this.getQualifiedName(), AbstractRoutine.this.type == null ? SQLDataType.RESULT : AbstractRoutine.this.type);
        }

        @Override
        public void accept(Context<?> ctx) {
            SQLDialect family = ctx.family();
            ArrayList fields = new ArrayList(AbstractRoutine.this.getInParameters0(ctx.configuration()).size());
            DataType returnType = this.getDataType();
            String name = null;
            for (Parameter<?> parameter : AbstractRoutine.this.getInParameters0(ctx.configuration())) {
                if (AbstractRoutine.this.inValuesDefaulted.contains(parameter)) continue;
                if (REQUIRE_DISAMBIGUATE_OVERLOADS.contains((Object)ctx.dialect())) {
                    if (AbstractRoutine.this.hasUnnamedParameters()) {
                        if (AbstractRoutine.this.pgArgNeedsCasting(parameter)) {
                            fields.add(new Cast(AbstractRoutine.this.getInValues().get(parameter), parameter.getDataType()));
                            continue;
                        }
                        fields.add(AbstractRoutine.this.getInValues().get(parameter));
                        continue;
                    }
                    if (AbstractRoutine.this.pgArgNeedsCasting(parameter)) {
                        fields.add(DSL.field("{0} := {1}", DSL.name(parameter.getName()), new Cast(AbstractRoutine.this.getInValues().get(parameter), parameter.getDataType())));
                        continue;
                    }
                    fields.add(DSL.field("{0} := {1}", DSL.name(parameter.getName()), AbstractRoutine.this.getInValues().get(parameter)));
                    continue;
                }
                fields.add(AbstractRoutine.this.getInValues().get(parameter));
            }
            Field result = new Function(name != null ? DSL.name(name) : AbstractRoutine.this.getQualifiedName(ctx), returnType, false, fields.toArray(Tools.EMPTY_FIELD));
            if (Boolean.TRUE.equals(Tools.settings(ctx.configuration()).isRenderScalarSubqueriesForStoredFunctions())) {
                result = DSL.select(result).asField();
            }
            ctx.visit(result);
        }
    }
}

