/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.ArrayTableEmulation;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.Tools;
import org.jooq.util.h2.H2DataType;

final class ArrayTable
extends AbstractTable<Record>
implements QOM.UNotYetImplemented {
    private final Field<?> array;
    private final FieldsImpl<Record> field;
    private final Name alias;
    private final Name[] fieldAliases;

    ArrayTable(Field<?> array) {
        this(array, Names.N_ARRAY_TABLE);
    }

    ArrayTable(Field<?> array, Name alias) {
        this(array, alias, null);
    }

    ArrayTable(Field<?> array, Name alias, Name[] fieldAliases) {
        super(TableOptions.expression(), alias);
        Name[] nameArray;
        Class arrayType = array.getDataType().getType().isArray() ? array.getDataType().getArrayComponentType() : Object.class;
        this.array = array;
        this.alias = alias;
        if (Tools.isEmpty(fieldAliases)) {
            Name[] nameArray2 = new Name[1];
            nameArray = nameArray2;
            nameArray2[0] = Names.N_COLUMN_VALUE;
        } else {
            nameArray = fieldAliases;
        }
        this.fieldAliases = nameArray;
        this.field = ArrayTable.init(arrayType, this.alias, this.fieldAliases[0]);
    }

    private static final FieldsImpl<Record> init(Class<?> arrayType, Name alias, Name fieldAlias) {
        if (Record.class.isAssignableFrom(arrayType)) {
            try {
                return new FieldsImpl<Record>(Tools.map(((Record)arrayType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).fields(), f -> DSL.field(DSL.name(alias.last(), f.getName()), f.getDataType())));
            }
            catch (Exception e) {
                throw new DataTypeException("Bad UDT Type : " + arrayType, e);
            }
        }
        return new FieldsImpl<Record>(DSL.field(alias.unqualifiedName().append(fieldAlias.unqualifiedName()), DSL.getDataType(arrayType)));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<Record> as(Name as) {
        return new ArrayTable(this.array, as);
    }

    @Override
    public final Table<Record> as(Name as, Name ... fields) {
        return new ArrayTable(this.array, as, fields);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    private final Table<Record> table(Configuration configuration) {
        switch (configuration.family()) {
            case H2: {
                return new H2ArrayTable().as(this.alias);
            }
            case HSQLDB: 
            case POSTGRES: 
            case YUGABYTEDB: {
                return new PostgresHSQLDBTable().as(this.alias, this.fieldAliases);
            }
        }
        if (this.array.getDataType().getType().isArray() && this.array instanceof Param) {
            return this.emulate();
        }
        return DSL.table("{0}", new QueryPart[]{this.array}).as(this.alias);
    }

    private final Table<Record> emulate() {
        return new ArrayTableEmulation((Object[])((Param)this.array).getValue()).as(this.alias, this.fieldAliases);
    }

    @Override
    final FieldsImpl<Record> fields0() {
        return this.field;
    }

    private class H2ArrayTable
    extends DialectArrayTable {
        private H2ArrayTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_TABLE).sql('(').visit(ArrayTable.this.fieldAliases == null || ArrayTable.this.fieldAliases.length == 0 ? Names.N_COLUMN_VALUE : ArrayTable.this.fieldAliases[0]).sql(' ');
            if (ArrayTable.this.array.getDataType().getType() == Object[].class) {
                ctx.sql(H2DataType.VARCHAR.getTypeName());
            } else {
                ctx.sql(ArrayTable.this.array.getDataType().getArrayComponentDataType().getTypeName(ctx.configuration()));
            }
            ctx.sql(" = ").visit(ArrayTable.this.array).sql(')');
        }
    }

    private class PostgresHSQLDBTable
    extends DialectArrayTable {
        private PostgresHSQLDBTable() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.visit(Keywords.K_UNNEST).sql('(').visit(ArrayTable.this.array).sql(")");
        }
    }

    private abstract class DialectArrayTable
    extends AbstractTable<Record>
    implements QOM.UTransient {
        DialectArrayTable() {
            super(TableOptions.expression(), ArrayTable.this.alias);
        }

        @Override
        public final Class<? extends Record> getRecordType() {
            return RecordImplN.class;
        }

        @Override
        final FieldsImpl<Record> fields0() {
            return ArrayTable.this.fields0();
        }
    }
}

