/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.QueryPart;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class FieldFunction<T>
extends AbstractField<Integer>
implements QOM.FieldFunction<T> {
    private final Field<T> field;
    private final QueryPartListView<Field<T>> arguments;

    FieldFunction(Field<T> field, Field<T>[] arguments) {
        super(Names.N_FIELD, SQLDataType.INTEGER);
        this.field = field;
        this.arguments = QueryPartListView.wrap((QueryPart[])arguments);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.arguments.size() > 1) {
                    ctx.visit(Names.N_FIELD).sql('(').visit(QueryPartListView.wrap((QueryPart[])Tools.combine(this.field, this.arguments.toArray((E[])Tools.EMPTY_FIELD)))).sql(')');
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptDefault(Context<?> ctx) {
        int size = this.arguments.size();
        if (size == 0) {
            ctx.visit(DSL.zero());
        } else {
            ArrayList<Field> args = new ArrayList<Field>();
            args.add(this.field);
            for (int i = 0; i < size; ++i) {
                args.add((Field)this.arguments.get(i));
                args.add(DSL.inline(i + 1));
            }
            args.add(DSL.inline(0));
            ctx.visit(DSL.decode((Field)args.get(0), (Field)args.get(1), (Field)args.get(2), (Object[])args.subList(3, args.size()).toArray(Tools.EMPTY_FIELD)));
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.field;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<T>> $arg2() {
        return QOM.unmodifiable(this.arguments);
    }

    @Override
    public final Function2<? super Field<T>, ? super QOM.UnmodifiableList<? extends Field<T>>, ? extends Field<Integer>> $constructor() {
        return (f, a) -> new FieldFunction((Field<?>)f, a.toArray(Tools.EMPTY_FIELD));
    }
}

