/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.GeneratorStatementType;
import org.jooq.InsertQuery;
import org.jooq.MergeMatchedStep;
import org.jooq.MergeOnConditionStep;
import org.jooq.Name;
import org.jooq.Named;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.AliasedSelect;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Excluded;
import org.jooq.impl.FieldMapForUpdate;
import org.jooq.impl.FieldMapsForInsert;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.StringUtils;

final class InsertQueryImpl<R extends Record>
extends AbstractStoreQuery<R, Field<?>, Field<?>>
implements InsertQuery<R>,
QOM.UNotYetImplemented {
    static final Clause[] CLAUSES = new Clause[]{Clause.INSERT};
    static final Set<SQLDialect> SUPPORT_INSERT_IGNORE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    static final Set<SQLDialect> SUPPORTS_OPTIONAL_DO_UPDATE_CONFLICT_TARGETS = SQLDialect.supportedBy(SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_DERIVED_COLUMN_LIST_IN_MERGE_USING = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.H2);
    static final Set<SQLDialect> NO_SUPPORT_SUBQUERY_IN_MERGE_USING = SQLDialect.supportedBy(SQLDialect.DERBY);
    static final Set<SQLDialect> REQUIRE_NEW_MYSQL_EXCLUDED_EMULATION = SQLDialect.supportedBy(SQLDialect.MYSQL);
    final FieldMapForUpdate updateMap;
    final FieldMapsForInsert insertMaps;
    Select<?> select;
    boolean defaultValues;
    boolean onDuplicateKeyUpdate;
    boolean onDuplicateKeyIgnore;
    Constraint onConstraint;
    UniqueKey<R> onConstraintUniqueKey;
    QueryPartList<Field<?>> onConflict;
    final ConditionProviderImpl onConflictWhere;
    final ConditionProviderImpl condition;

    InsertQueryImpl(Configuration configuration, WithImpl with, Table<R> into) {
        super(configuration, with, into);
        this.updateMap = new FieldMapForUpdate(into, FieldMapForUpdate.SetClause.INSERT, Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
        this.insertMaps = new FieldMapsForInsert(into);
        this.onConflictWhere = new ConditionProviderImpl();
        this.condition = new ConditionProviderImpl();
    }

    @Override
    public final void newRecord() {
        this.insertMaps.newRecord();
    }

    @Override
    protected final Map<Field<?>, Field<?>> getValues() {
        return this.insertMaps.lastMap();
    }

    final FieldMapsForInsert getInsertMaps() {
        return this.insertMaps;
    }

    final Select<?> getSelect() {
        return this.select;
    }

    @Override
    public final void addRecord(R record) {
        this.newRecord();
        this.setRecord(record);
    }

    @Override
    public final void onConflict(Field<?> ... fields) {
        this.onConflict(Arrays.asList(fields));
    }

    @Override
    public final void onConflict(Collection<? extends Field<?>> fields) {
        this.onConflict = new QueryPartList((Iterable<Field<?>>)fields).qualify(false);
    }

    @Override
    public final void onConflictWhere(Condition conditions) {
        this.onConflictWhere.addConditions(conditions);
    }

    @Override
    public final void onConflictOnConstraint(Constraint constraint) {
        this.onConflictOnConstraint0(constraint);
    }

    @Override
    public void onConflictOnConstraint(UniqueKey<R> constraint) {
        if (StringUtils.isEmpty(constraint.getName())) {
            throw new IllegalArgumentException("UniqueKey's name is not specified");
        }
        this.onConstraintUniqueKey = constraint;
        this.onConflictOnConstraint0(DSL.constraint(DSL.name(constraint.getName())));
    }

    @Override
    public final void onConflictOnConstraint(Name constraint) {
        this.onConflictOnConstraint0(DSL.constraint(constraint));
    }

    private final void onConflictOnConstraint0(Constraint constraint) {
        this.onConstraint = constraint;
        if (this.onConstraintUniqueKey == null) {
            this.onConstraintUniqueKey = Tools.findAny(this.table().getKeys(), key -> constraint.getName().equals(key.getName()));
        }
    }

    @Override
    public final void onDuplicateKeyUpdate(boolean flag) {
        this.onDuplicateKeyIgnore = false;
        this.onDuplicateKeyUpdate = flag;
    }

    @Override
    public final void onDuplicateKeyIgnore(boolean flag) {
        this.onDuplicateKeyUpdate = false;
        this.onDuplicateKeyIgnore = flag;
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, T value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, Field<T> value) {
        this.updateMap.put(field, Tools.field(value, field));
    }

    @Override
    public final void addValuesForUpdate(Map<?, ?> map) {
        this.updateMap.set(map);
    }

    @Override
    public final void addConditions(Condition conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void setDefaultValues() {
        this.defaultValues = true;
    }

    private final boolean defaultValues(Configuration c) {
        return this.defaultValues;
    }

    @Override
    public final void setSelect(Field<?>[] f, Select<?> s) {
        this.setSelect(Arrays.asList(f), s);
    }

    @Override
    public final void setSelect(Collection<? extends Field<?>> f, Select<?> s) {
        this.insertMaps.addFields(f);
        this.select = s;
    }

    @Override
    public final void addValues(Map<?, ?> map) {
        this.insertMaps.set(map);
    }

    @Override
    final void accept0(Context<?> ctx) {
        if (this.onDuplicateKeyUpdate) {
            switch (ctx.family()) {
                case POSTGRES: 
                case SQLITE: 
                case YUGABYTEDB: {
                    ctx.data(Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE, ctx.family() == SQLDialect.SQLITE, c -> this.toSQLInsert((Context<?>)c, false));
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_CONFLICT).sql(' ');
                    if (this.onConstraint != null) {
                        ctx.data(Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true);
                        ctx.visit(Keywords.K_ON_CONSTRAINT).sql(' ').visit(this.onConstraint);
                        ctx.data().remove(Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE);
                    } else if (this.onConflict != null && this.onConflict.size() > 0) {
                        ctx.sql('(').visit(this.onConflict).sql(')');
                    } else if (!SUPPORTS_OPTIONAL_DO_UPDATE_CONFLICT_TARGETS.contains((Object)ctx.dialect()) || this.onConflictWhere.hasWhere()) {
                        if (this.table().getPrimaryKey() == null) {
                            ctx.sql("[unknown primary key]");
                        } else {
                            ctx.sql('(').qualify(false, c -> c.visit(new FieldsImpl(this.table().getPrimaryKey().getFields()))).sql(')');
                        }
                    }
                    this.acceptOnConflictWhere(ctx);
                    ctx.formatSeparator().visit(Keywords.K_DO_UPDATE).formatSeparator().visit(Keywords.K_SET).formatIndentStart().formatSeparator().visit(this.updateMapComputedOnClientStored(ctx)).formatIndentEnd();
                    if (this.condition.hasWhere()) {
                        ctx.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.condition);
                    }
                    ctx.end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: {
                    ctx.visit(this.toMerge(ctx));
                    break;
                }
                default: {
                    boolean oldQualify = ctx.qualify();
                    boolean newQualify = ctx.family() != SQLDialect.H2 && oldQualify;
                    FieldMapForUpdate um = this.updateMapComputedOnClientStored(ctx);
                    boolean requireNewMySQLExcludedEmulation = REQUIRE_NEW_MYSQL_EXCLUDED_EMULATION.contains((Object)ctx.dialect()) && Tools.anyMatch(um.values(), v -> v instanceof Excluded);
                    Set<Field<?>> keys = this.toSQLInsert(ctx, requireNewMySQLExcludedEmulation);
                    if (requireNewMySQLExcludedEmulation && this.select == null) {
                        ctx.formatSeparator().visit(Keywords.K_AS).sql(' ').visit(DSL.name("t"));
                    }
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_DUPLICATE_KEY_UPDATE).formatIndentStart().formatSeparator().qualify(newQualify);
                    if (this.condition.hasWhere()) {
                        ctx.data(Tools.SimpleDataKey.DATA_ON_DUPLICATE_KEY_WHERE, this.condition.getWhere());
                    }
                    if (requireNewMySQLExcludedEmulation) {
                        um.replaceAll((k, v) -> {
                            if (v instanceof Excluded) {
                                Excluded e = (Excluded)v;
                                return keys.contains(e.$field()) ? v : Tools.qualify(this.table(), e.$field());
                            }
                            return v;
                        });
                    }
                    ctx.visit(um);
                    if (this.condition.hasWhere()) {
                        ctx.data().remove(Tools.SimpleDataKey.DATA_ON_DUPLICATE_KEY_WHERE);
                    }
                    ctx.qualify(oldQualify).formatIndentEnd().end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
            }
        } else if (this.onDuplicateKeyIgnore) {
            switch (ctx.family()) {
                case FIREBIRD: 
                case IGNITE: {
                    ctx.visit(this.toInsertSelect(ctx));
                    break;
                }
                case POSTGRES: 
                case SQLITE: 
                case YUGABYTEDB: {
                    ctx.data(Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE, ctx.family() == SQLDialect.SQLITE, c -> this.toSQLInsert((Context<?>)c, false));
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_CONFLICT);
                    if (this.onConstraint != null) {
                        ctx.data(Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE, true, c -> c.sql(' ').visit(Keywords.K_ON_CONSTRAINT).sql(' ').visit(this.onConstraint));
                    } else if (this.onConflict != null && this.onConflict.size() > 0) {
                        ctx.sql(" (").visit(this.onConflict).sql(')');
                        this.acceptOnConflictWhere(ctx);
                    }
                    ctx.formatSeparator().visit(Keywords.K_DO_NOTHING).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case CUBRID: {
                    FieldMapForUpdate update = new FieldMapForUpdate(this.table(), FieldMapForUpdate.SetClause.INSERT, Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
                    Field<?> field = this.table().field(0);
                    update.put(field, field);
                    this.toSQLInsert(ctx, false);
                    ctx.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).visit(Keywords.K_ON_DUPLICATE_KEY_UPDATE).sql(' ').visit(update).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
                case H2: 
                case HSQLDB: {
                    ctx.visit(this.toMerge(ctx));
                    break;
                }
                case DERBY: {
                    if (this.select != null) {
                        ctx.visit(this.toInsertSelect(ctx));
                        break;
                    }
                    ctx.visit(this.toMerge(ctx));
                    break;
                }
                default: {
                    this.toSQLInsert(ctx, false);
                    ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                    break;
                }
            }
        } else {
            this.toSQLInsert(ctx, false);
            ctx.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
        }
        ctx.start(Clause.INSERT_RETURNING);
        this.toSQLReturning(ctx);
        ctx.end(Clause.INSERT_RETURNING);
    }

    private final void acceptOnConflictWhere(Context<?> ctx) {
        if (this.onConflictWhere.hasWhere()) {
            ctx.qualify(false, c -> c.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(this.onConflictWhere.getWhere()));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final Set<Field<?>> toSQLInsert(Context<?> ctx, boolean requireNewMySQLExcludedEmulation) {
        ctx.start(Clause.INSERT_INSERT_INTO).visit(Keywords.K_INSERT).sql(' ');
        if (this.onDuplicateKeyIgnore && SUPPORT_INSERT_IGNORE.contains((Object)ctx.dialect())) {
            ctx.visit(Keywords.K_IGNORE).sql(' ');
        }
        ctx.visit(Keywords.K_INTO).sql(' ').declareTables(true, c -> c.visit(this.table((Context<?>)c)));
        Set<Field<?>> fields = this.insertMaps.toSQLReferenceKeys(ctx);
        ctx.end(Clause.INSERT_INSERT_INTO);
        if (this.select != null) {
            Set<Field<?>> keysFlattened = this.insertMaps.keysFlattened(ctx, GeneratorStatementType.INSERT);
            if (keysFlattened.size() == 0) {
                ctx.data(Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST, true);
            }
            ctx.data(Tools.BooleanDataKey.DATA_INSERT_SELECT, true);
            Select<Record> s = this.select;
            if (requireNewMySQLExcludedEmulation) {
                s = DSL.selectFrom(s.asTable(DSL.table(DSL.name("t")), keysFlattened));
            }
            FieldMapsForInsert.toSQLInsertSelect(ctx, s);
            ctx.data().remove(Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST);
            ctx.data().remove(Tools.BooleanDataKey.DATA_INSERT_SELECT);
        } else if (this.defaultValues(ctx.configuration())) {
            switch (ctx.family()) {
                case DERBY: 
                case MARIADB: 
                case MYSQL: {
                    this.acceptDefaultValuesEmulation(ctx, this.table().fields().length);
                    break;
                }
                default: {
                    ctx.formatSeparator().visit(Keywords.K_DEFAULT_VALUES);
                    break;
                }
            }
        } else {
            ctx.visit(this.insertMaps);
        }
        return fields;
    }

    private final void acceptDefaultValuesEmulation(Context<?> ctx, int length) {
        ctx.formatSeparator().visit(Keywords.K_VALUES).sql(" (").visit(QueryPartListView.wrap(Collections.nCopies(length, Keywords.K_DEFAULT))).sql(')');
    }

    private final List<List<? extends Field<?>>> conflictingKeys(Context<?> ctx) {
        if (this.onConflict != null && this.onConflict.size() > 0) {
            return Collections.singletonList(this.onConflict);
        }
        if (this.onConstraintUniqueKey != null) {
            return Collections.singletonList(this.onConstraintUniqueKey.getFields());
        }
        if (Boolean.TRUE.equals(Tools.settings(ctx.configuration()).isEmulateOnDuplicateKeyUpdateOnPrimaryKeyOnly())) {
            return Collections.singletonList(this.table().getPrimaryKey().getFields());
        }
        return Tools.map(this.table().getKeys(), k -> k.getFields());
    }

    private final QueryPart toInsertSelect(Context<?> ctx) {
        List<List<Field<?>>> keys = this.conflictingKeys(ctx);
        if (!keys.isEmpty()) {
            Select rows = null;
            Set<Field<?>> fields = this.insertMaps.keysFlattened(ctx, GeneratorStatementType.INSERT);
            if (this.select != null) {
                HashMap map = new HashMap();
                Field<?>[] names = Tools.fields(Tools.degree(this.select));
                ArrayList f = new ArrayList(fields);
                for (int i = 0; i < fields.size() && i < names.length; ++i) {
                    map.put((Field)f.get(i), names[i]);
                }
                rows = DSL.selectFrom(this.select.asTable(DSL.table(DSL.name("t")), names)).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table()).where(this.matchByConflictingKeys(ctx, map)));
            } else {
                for (Map<Field<?>, Field<?>> map : this.insertMaps.maps()) {
                    SelectConditionStep row = DSL.select(Tools.aliasedFields(map.entrySet().stream().filter(e -> fields.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()))).whereNotExists(DSL.selectOne().from((TableLike<?>)this.table()).where(this.matchByConflictingKeys(ctx, map)));
                    if (rows == null) {
                        rows = row;
                        continue;
                    }
                    rows = rows.unionAll(row);
                }
            }
            return ctx.dsl().insertInto(this.table()).columns(fields).select(DSL.selectFrom(rows.asTable("t")));
        }
        return DSL.sql("[ The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into tables without any known keys : " + this.table() + " ]");
    }

    private final QueryPart toMerge(Context<?> ctx) {
        if (this.onConflict != null && this.onConflict.size() > 0 || this.onConstraint != null || !this.table().getKeys().isEmpty()) {
            MergeOnConditionStep on;
            SelectField t;
            Set<Field<?>> k = this.insertMaps.keysFlattened(ctx, null);
            Set<Field<?>> f = null;
            if (!NO_SUPPORT_SUBQUERY_IN_MERGE_USING.contains((Object)ctx.dialect())) {
                Select<?> s;
                f = k.isEmpty() ? Arrays.asList(this.table().fields()) : k;
                Select<Object> select = s = this.select != null ? this.select : this.insertMaps.insertSelect(ctx, null);
                if (s == null) {
                    s = DSL.select(Tools.map(f, x -> x.getDataType().defaulted() ? x.getDataType().default_() : DSL.NULL(x)));
                }
                t = NO_SUPPORT_DERIVED_COLUMN_LIST_IN_MERGE_USING.contains((Object)ctx.dialect()) ? new AliasedSelect(s, true, true, false, Tools.map(f, Named::getUnqualifiedName, Name[]::new)).as("t") : s.asTable("t", Tools.map(f, Field::getName, String[]::new));
            } else {
                t = null;
            }
            MergeMatchedStep notMatched = on = t != null ? ctx.dsl().mergeInto(this.table()).using((TableLike<?>)((Object)t)).on(this.matchByConflictingKeys(ctx, (Table<?>)t)) : ctx.dsl().mergeInto(this.table()).usingDual().on(this.matchByConflictingKeys(ctx, this.insertMaps.lastMap()));
            if (this.onDuplicateKeyUpdate) {
                FieldMapForUpdate um = new FieldMapForUpdate(this.updateMap, FieldMapForUpdate.SetClause.INSERT);
                um.replaceAll((key, v) -> {
                    if (v instanceof Excluded) {
                        Excluded e = (Excluded)v;
                        if (t != null) {
                            return Tools.orElse(t.field(e.$field()), () -> Tools.qualify(this.table(), e.$field()));
                        }
                        return Tools.orElse(this.insertMaps.lastMap().get(e.$field()), () -> Tools.qualify(this.table(), e.$field()));
                    }
                    return v;
                });
                um = this.updateMapComputedOnClientStored(ctx, um);
                notMatched = this.condition.hasWhere() ? on.whenMatchedAnd(this.condition.getWhere()).thenUpdate().set(um) : on.whenMatchedThenUpdate().set(um);
            }
            return t != null ? notMatched.whenNotMatchedThenInsert(f).values(t.fields()) : notMatched.whenNotMatchedThenInsert(k).values(this.insertMaps.lastMap().entrySet().stream().filter(e -> k.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
        }
        return DSL.sql("[ The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be emulated when inserting into non-updatable tables : " + this.table() + " ]");
    }

    private final FieldMapForUpdate updateMapComputedOnClientStored(Context<?> ctx) {
        return this.updateMapComputedOnClientStored(ctx, new FieldMapForUpdate(this.updateMap, FieldMapForUpdate.SetClause.INSERT));
    }

    private final FieldMapForUpdate updateMapComputedOnClientStored(Context<?> ctx, FieldMapForUpdate um) {
        return um;
    }

    private final Condition matchByConflictingKeys(Context<?> ctx, Map<Field<?>, Field<?>> map) {
        Condition or = null;
        if (this.onConstraint != null && this.onConstraintUniqueKey == null) {
            return DSL.condition("[ cannot create predicate from constraint with unknown columns ]");
        }
        for (List<Field<?>> fields : this.conflictingKeys(ctx)) {
            Condition and = null;
            Iterator<Field<?>> iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field<?> field;
                Field<?> f = field = iterator.next();
                Condition other = this.matchByConflictingKey(ctx, f, map.get(f));
                and = and == null ? other : and.and(other);
            }
            or = or == null ? and : or.or(and);
        }
        return or;
    }

    private final Condition matchByConflictingKeys(Context<?> ctx, Table<?> s) {
        Condition or = null;
        if (this.onConstraint != null && this.onConstraintUniqueKey == null) {
            return DSL.condition("[ cannot create predicate from constraint with unknown columns ]");
        }
        for (List<Field<?>> fields : this.conflictingKeys(ctx)) {
            Condition and = null;
            Iterator<Field<?>> iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field<?> field;
                Field<?> f = field = iterator.next();
                Condition other = this.matchByConflictingKey(ctx, f, s.field(f));
                and = and == null ? other : and.and(other);
            }
            or = or == null ? and : or.or(and);
        }
        return or;
    }

    private final <T> Condition matchByConflictingKey(Context<?> ctx, Field<T> f, Field<T> v) {
        return f.eq(v);
    }

    @Override
    public final boolean isExecutable() {
        return this.insertMaps.isExecutable() || this.defaultValues(this.configuration()) || this.select != null;
    }
}

