/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.JSONEntry;
import org.jooq.JSONEntryValueStep;
import org.jooq.Param;
import org.jooq.Record1;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.Select;
import org.jooq.conf.NestedCollectionEmulation;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AbstractRowAsField;
import org.jooq.impl.ConvertedDataType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.impl.Val;

final class JSONEntryImpl<T>
extends AbstractQueryPart
implements JSONEntry<T>,
JSONEntryValueStep {
    static final Set<SQLDialect> SUPPORT_JSON_MERGE_PRESERVE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<String> key;
    private final Field<T> value;

    JSONEntryImpl(Field<String> key) {
        this(key, null);
    }

    JSONEntryImpl(Field<String> key, Field<T> value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public final Field<String> key() {
        return this.key;
    }

    @Override
    public final Field<T> value() {
        return this.value;
    }

    public final <X> JSONEntry<X> value(X newValue) {
        return this.value(Tools.field(newValue));
    }

    public final <X> JSONEntry<X> value(Field<X> newValue) {
        return new JSONEntryImpl<X>(this.key, newValue);
    }

    public final <X> JSONEntry<X> value(Select<? extends Record1<X>> newValue) {
        return this.value(DSL.field(newValue));
    }

    @Override
    public void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                ctx.visit(this.key).sql(", ").visit(JSONEntryImpl.jsonCast(ctx, this.value));
                break;
            }
            default: {
                ctx.visit(Keywords.K_KEY).sql(' ').visit(this.key).sql(' ').visit(Keywords.K_VALUE).sql(' ').visit(JSONEntryImpl.jsonCast(ctx, this.value));
            }
        }
    }

    static final Function<? super Field<?>, ? extends Field<?>> jsonCastMapper(Context<?> ctx) {
        return field -> JSONEntryImpl.jsonCast(ctx, field);
    }

    static final Field<?> jsonCast(Context<?> ctx, Field<?> field) {
        DataType type = field.getDataType();
        switch (ctx.family()) {
            case H2: {
                if (JSONEntryImpl.isType(type, UUID.class)) {
                    return field.cast(SQLDataType.VARCHAR(36));
                }
                if (type.isEnum()) {
                    return field.cast(SQLDataType.VARCHAR);
                }
                if (type.isTemporal()) {
                    return field.cast(SQLDataType.VARCHAR);
                }
                if (!type.isBinary()) break;
                return DSL.function(Names.N_RAWTOHEX, SQLDataType.VARCHAR, field);
            }
            case MARIADB: 
            case MYSQL: {
                if (type.getSQLDataType() == SQLDataType.BIT) {
                    return field.cast(SQLDataType.BOOLEAN);
                }
                if (!JSONEntryImpl.isType(type, Boolean.class)) break;
                return DSL.inlined(field);
            }
            case SQLITE: {
                if (JSONEntryImpl.isType(type, Boolean.class)) {
                    return DSL.function(Names.N_JSON, SQLDataType.JSON, JSONEntryImpl.booleanCase(field));
                }
                if (!type.isBinary()) break;
                return DSL.when(field.isNotNull(), DSL.function(Names.N_HEX, SQLDataType.VARCHAR, field));
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                if (field instanceof Param) {
                    if (field.getType() != Object.class) {
                        return field.cast(field.getDataType());
                    }
                    return field.cast(SQLDataType.VARCHAR);
                }
                return field;
            }
        }
        return field;
    }

    private static Field<String> booleanCase(Field<?> field) {
        return DSL.case_(field).when((Field<?>)DSL.inline(true), DSL.inline("true")).when(DSL.inline(false), DSL.inline("false"));
    }

    static final <T> Field<T> unescapeNestedJSON(Context<?> ctx, Field<T> value) {
        if (JSONEntryImpl.isJSON(ctx, value.getDataType())) {
            switch (ctx.family()) {
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    return DSL.function(Names.N_JSON_EXTRACT, value.getDataType(), value, DSL.inline("$"));
                }
            }
        }
        return value;
    }

    static final boolean isType(DataType<?> t, Class<?> type) {
        if (t instanceof ConvertedDataType) {
            ConvertedDataType c = (ConvertedDataType)t;
            t = c.delegate();
        }
        return t.getType() == type;
    }

    static final boolean isJSON(Context<?> ctx, DataType<?> type) {
        DataType<Object> dataType;
        if (type instanceof ConvertedDataType) {
            ConvertedDataType c = (ConvertedDataType)type;
            dataType = c.delegate();
        } else {
            dataType = type;
        }
        DataType<?> t = dataType;
        return t.isJSON() || t.isEmbeddable() && AbstractRowAsField.forceMultisetContent(ctx, () -> t.getRow().size() > 1) && JSONEntryImpl.emulateMultisetWithJSON(ctx) || t.isRecord() && AbstractRowAsField.forceMultisetContent(ctx, () -> t.getRow().size() > 1) && JSONEntryImpl.emulateMultisetWithJSON(ctx) || t.isMultiset() && JSONEntryImpl.emulateMultisetWithJSON(ctx);
    }

    private static final boolean emulateMultisetWithJSON(Scope scope) {
        return Tools.emulateMultiset(scope.configuration()) == NestedCollectionEmulation.JSON || Tools.emulateMultiset(scope.configuration()) == NestedCollectionEmulation.JSONB;
    }

    static final Field<?> booleanValAsVarchar(Field<?> field) {
        Field<String> field2;
        if (field instanceof Val) {
            Val v = (Val)field;
            field2 = v.convertTo0(SQLDataType.VARCHAR);
        } else {
            field2 = JSONEntryImpl.booleanCase(field);
        }
        return field2;
    }

    static final Field<?> jsonMerge(Scope scope, String empty, Field<?> ... fields) {
        return DSL.function(SUPPORT_JSON_MERGE_PRESERVE.contains((Object)scope.dialect()) ? Names.N_JSON_MERGE_PRESERVE : Names.N_JSON_MERGE, fields[0].getDataType(), Tools.combine(DSL.inline(empty), fields));
    }

    @Override
    public final Field<String> $key() {
        return this.key;
    }

    @Override
    public final Field<?> $value() {
        return this.value;
    }
}

