/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Function4;
import org.jooq.JSONB;
import org.jooq.JSONEntry;
import org.jooq.JSONObjectNullStep;
import org.jooq.JSONObjectReturningStep;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.JSONArray;
import org.jooq.impl.JSONArrayAgg;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.JSONNull;
import org.jooq.impl.JSONReturning;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.ScalarSubquery;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class JSONObject<T>
extends AbstractField<T>
implements QOM.JSONObject<T>,
JSONObjectNullStep<T>,
JSONObjectReturningStep<T> {
    final DataType<T> type;
    final QueryPartListView<? extends JSONEntry<?>> entries;
    QOM.JSONOnNull onNull;
    DataType<?> returning;

    JSONObject(DataType<T> type, Collection<? extends JSONEntry<?>> entries) {
        this(type, entries, null, null);
    }

    JSONObject(DataType<T> type, Collection<? extends JSONEntry<?>> entries, QOM.JSONOnNull onNull, DataType<?> returning) {
        super(Names.N_JSON_OBJECT, type);
        this.type = type;
        this.entries = new QueryPartList((Iterable<JSONEntry<?>>)entries);
        this.onNull = onNull;
        this.returning = returning;
    }

    @Override
    public final JSONObject<T> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONObject<T> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONObject<T> returning(DataType<?> returning) {
        this.returning = returning;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                    ctx.visit(DSL.unquotedName(this.getDataType().getType() == JSONB.class ? "jsonb_strip_nulls" : "json_strip_nulls")).sql('(');
                }
                ctx.visit(DSL.unquotedName(this.getDataType().getType() == JSONB.class ? "jsonb_build_object" : "json_build_object")).sql('(').visit(QueryPartCollectionView.wrap(this.entries)).sql(')');
                if (this.onNull != QOM.JSONOnNull.ABSENT_ON_NULL) break;
                ctx.sql(')');
                break;
            }
            case MARIADB: {
                JSONEntry first;
                if (this.entries.size() > 1) {
                    ctx.visit(JSONEntryImpl.jsonMerge(ctx, "{}", Tools.map(this.entries, e -> DSL.jsonObject(e), Field[]::new)));
                    break;
                }
                if (!this.entries.isEmpty() && JSONObject.isJSONArray((first = (JSONEntry)this.entries.iterator().next()).value())) {
                    ctx.visit(DSL.jsonObject(DSL.key(first.key()).value(JSONEntryImpl.jsonMerge(ctx, "[]", first.value()))));
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private static final boolean isJSONArray(Field<?> field) {
        return field instanceof JSONArray || field instanceof JSONArrayAgg || field instanceof ScalarSubquery && JSONObject.isJSONArray(((ScalarSubquery)field).query.getSelect().get(0));
    }

    private final void acceptStandard(Context<?> ctx) {
        JSONNull jsonNull = this.entries.isEmpty() && ctx.family() == SQLDialect.H2 ? new JSONNull(QOM.JSONOnNull.NULL_ON_NULL) : new JSONNull(this.onNull);
        JSONReturning jsonReturning = new JSONReturning(this.returning);
        ctx.visit(Names.N_JSON_OBJECT).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{QueryPartCollectionView.wrap(this.entries), jsonNull, jsonReturning}).separator("")).sql(')');
    }

    @Override
    public final DataType<T> $type() {
        return this.type;
    }

    @Override
    public final QOM.UnmodifiableList<? extends JSONEntry<?>> $entries() {
        return QOM.unmodifiable(this.entries);
    }

    @Override
    public final QOM.JSONOnNull $onNull() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $returning() {
        return this.returning;
    }

    @Override
    public final QOM.JSONObject<T> $type(DataType<T> newValue) {
        return this.$constructor().apply(newValue, this.$entries(), this.$onNull(), this.$returning());
    }

    @Override
    public final QOM.JSONObject<T> $entries(Collection<? extends JSONEntry<?>> newValue) {
        return this.$constructor().apply(this.$type(), newValue, this.$onNull(), this.$returning());
    }

    @Override
    public final QOM.JSONObject<T> $onNull(QOM.JSONOnNull newValue) {
        return this.$constructor().apply(this.$type(), this.$entries(), newValue, this.$returning());
    }

    @Override
    public final QOM.JSONObject<T> $returning(DataType<?> newValue) {
        return this.$constructor().apply(this.$type(), this.$entries(), this.$onNull(), newValue);
    }

    public final Function4<? super DataType<T>, ? super Collection<? extends JSONEntry<?>>, ? super QOM.JSONOnNull, ? super DataType<?>, ? extends QOM.JSONObject<T>> $constructor() {
        return (a1, a2, a3, a4) -> new JSONObject(a1, (Collection<? extends JSONEntry<?>>)((Collection<JSONEntry<?>>)a2), (QOM.JSONOnNull)((Object)a3), (DataType<?>)a4);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONObject) {
            QOM.JSONObject o = (QOM.JSONObject)that;
            return StringUtils.equals(this.$type(), o.$type()) && StringUtils.equals(this.$entries(), o.$entries()) && StringUtils.equals((Object)this.$onNull(), (Object)o.$onNull()) && StringUtils.equals(this.$returning(), o.$returning());
        }
        return super.equals(that);
    }
}

