/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QualifiedRecord;
import org.jooq.RenderContext;
import org.jooq.Scope;
import org.jooq.conf.ParamType;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractParam;
import org.jooq.impl.Cast;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.Tools;

final class QualifiedRecordConstant<R extends QualifiedRecord<R>>
extends AbstractParam<R>
implements QOM.UNotYetImplemented {
    QualifiedRecordConstant(R value) {
        super(value, value.getQualifier().getDataType());
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext ctx) {
        ParamType paramType = ctx.paramType();
        if (this.isInline()) {
            ctx.paramType(ParamType.INLINED);
        }
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.toSQLInline(ctx);
                break;
            }
            default: {
                this.toSQLInline(ctx);
            }
        }
        if (this.isInline()) {
            ctx.paramType(paramType);
        }
    }

    private final void toSQLInline(RenderContext ctx) {
        Cast.renderCastIf(ctx, c -> {
            switch (c.family()) {
                case POSTGRES: 
                case YUGABYTEDB: {
                    c.visit(Keywords.K_ROW);
                    break;
                }
                default: {
                    c.visit(((QualifiedRecord)this.value).getQualifier());
                }
            }
            c.sql('(');
            String separator = "";
            for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                c.sql(separator);
                c.visit(DSL.val(((QualifiedRecord)this.value).get(field), field));
                separator = ", ";
            }
            c.sql(')');
        }, c -> c.visit(((QualifiedRecord)this.value).getQualifier()), () -> DefaultBinding.DefaultRecordBinding.REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()));
    }

    @Deprecated
    private final String getInlineConstructor(RenderContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return "ROW";
            }
        }
        return Tools.getMappedUDTName((Scope)ctx, (QualifiedRecord)this.value);
    }

    final void bind0(BindContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    ctx.visit(DSL.val(((QualifiedRecord)this.value).get(field)));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + ctx.dialect());
            }
        }
    }
}

