/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Shl<T extends Number>
extends AbstractField<T>
implements QOM.Shl<T> {
    final Field<T> value;
    final Field<? extends Number> count;

    Shl(Field<T> value, Field<? extends Number> count) {
        super(Names.N_SHL, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, count));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.count = Tools.nullSafeNotNull(count, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                return true;
            }
            case H2: {
                return true;
            }
            case HSQLDB: {
                return false;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(DSL.function(Names.N_BIN_SHL, this.getDataType(), this.value, this.count));
                break;
            }
            case H2: {
                ctx.visit(DSL.function(Names.N_LSHIFT, this.getDataType(), this.value, this.count));
                break;
            }
            case HSQLDB: {
                ctx.visit(Internal.imul(this.value, Tools.castIfNeeded(DSL.power(DSL.two(), this.count), this.value)));
                break;
            }
            default: {
                ctx.sql('(').visit(this.value).sql(" << ").visit(this.count).sql(')');
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.count;
    }

    @Override
    public final QOM.Shl<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<Number>)this.$arg2());
    }

    @Override
    public final QOM.Shl<T> $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<? extends Number>, ? extends QOM.Shl<T>> $constructor() {
        return (a1, a2) -> new Shl(a1, (Field<? extends Number>)((Field<Number>)a2));
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Shl) {
            QOM.Shl o = (QOM.Shl)that;
            return StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$count(), o.$count());
        }
        return super.equals(that);
    }
}

