/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.impl.AbstractRowAsField;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.RecordDataType;
import org.jooq.impl.ScopeMappableWrapper;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.Tools;

final class TableAsField<R extends Record>
extends AbstractRowAsField<R>
implements QOM.TableAsField<R>,
ScopeMappableWrapper<TableAsField<R>, Table<R>> {
    static final Set<SQLDialect> NO_NATIVE_SUPPORT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    final Table<R> table;

    TableAsField(Table<R> table) {
        this(table, table.getQualifiedName());
    }

    TableAsField(Table<R> table, Name as) {
        super(as, new RecordDataType(((AbstractTable)table).fieldsRow(), table.getRecordType(), table.getName()));
        this.table = table;
    }

    @Override
    final Table<R> fields0() {
        return this.table;
    }

    @Override
    final Class<R> getRecordType() {
        return this.table.getRecordType();
    }

    @Override
    final void acceptDefault(Context<?> ctx) {
        if (NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            ctx.data(Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true, c -> c.visit(new SelectFieldList((SelectFieldOrAsterisk[])this.emulatedFields((Configuration)ctx.configuration()).fields.fields)));
        } else {
            ctx.visit(Keywords.K_CAST).sql(" (").visit(Keywords.K_ROW).sql(" (").visit(this.table).sql(".*) ").visit(Keywords.K_AS).sql(' ').visit(Tools.unalias(this.table)).sql(')');
        }
    }

    @Override
    public Field<R> as(Name alias) {
        return new TableAsField<R>(this.table, alias);
    }

    @Override
    public final Table<R> $table() {
        return this.table;
    }

    @Override
    public final TableAsField<R> wrap(Table<R> wrapped) {
        return new TableAsField<R>(wrapped, this.getQualifiedName());
    }
}

