<#ftl output_format="LaTeX" strict_syntax="true">
<#macro base_letter subject>
\documentclass[
    12pt,
    a4paper,
    letter,
    parskip=full,
    fromalign=right,
    <#if headless>
        firsthead=false,
    </#if>
    version=last
]{scrlttr2}

\usepackage{scrlayer-scrpage}
\usepackage{ucs}
\usepackage[utf8x]{inputenc}
\usepackage[ngerman]{babel}
\usepackage[T1]{fontenc}
\usepackage[official]{eurosym}
\usepackage{graphicx}
\usepackage{hyperref}
\usepackage{tabularx}
\usepackage{xpatch}
\usepackage{xltabular}

<#if demo?? && demo>
    \usepackage{draftwatermark}
    \SetWatermarkText{DEMO}
    \SetWatermarkScale{5}
</#if>

<#if debug?? && debug>
	\LoadLetterOption{visualize}
	\showfields{head,foot,address,location,refline}
</#if>

\sloppy

\pagestyle{plain}
\xapptocmd\opening{\thispagestyle{plain}}{}{}
\renewcommand*{\raggedsignature}{\raggedright}

\setplength{locwidth}{8cm}
\KOMAoptions{footwidth=\useplength{firstfootwidth}}
\setkomafont{pagefoot}{\normalfont\scriptsize}

<#if logo??>
	\firsthead{
		\begin{minipage}[c][3cm][c]{\textwidth}
			\raggedleft
			\includegraphics[height=1.75cm]{${logo}}
		\end{minipage}
	}
</#if>

\setkomavar{fromname}{${settings["company.name"]}}
\setkomavar{fromaddress}{
	<#if settings["company.salutation"] != "">
		${bundle["Salutation." + settings["company.salutation"] + ".display"]}
		${settings["company.firstName"]} ${settings["company.lastName"]} \\
	</#if>
	${settings["company.address1"]} \\
	${settings["company.address2"]}
	<#if document.country != settings["company.country"]>
		\\ ${countries[settings["company.country"]]}
	</#if>
}
<#if document.country == settings["company.country"]>
	\setkomavar{backaddress}{${settings["company.name"]}\\${settings["company.address1"]}\\${settings["company.address2"]}}
<#else>
	\setkomavar{backaddress}{${settings["company.address1"]}\\${settings["company.address2"]}\\${countries[settings["company.country"]]}}
</#if>

\setkomavar{location}{\raggedleft
    \begin{tabular}{ll}
        <#if customer??>
            ${bundle["Customer.NUMBER"]}: & ${customer.number} \\
        </#if>
        <#if vendor??>
            ${bundle["Vendor.NUMBER"]}: & ${vendor.number} \\
        </#if>
        <#if order??>
            ${bundle["Order.NUMBER"]}: & ${order.number} \\
        </#if>
        ${bundle["Document.NUMBER." + document.type.numberType]}: & ${document.number} \\
		<#list parents as parent>
			<#if parent.type == "RECEIPT">
				${bundle["Document.NUMBER." + parent.type]}: & ${parent.number} \\
			</#if>
		</#list>
		${bundle["Document.DATE"]}: & ${document.date.format('dd.MM.yyyy')} \\
        <#if document.type.displayDueDate && document.dueDate??>
            ${bundle["Document.DUE_DATE." + document.type]}: & ${document.dueDate.format('dd.MM.yyyy')} \\
        </#if>
        <#if document.serviceType??>
            ${bundle["DocumentServiceType." + document.serviceType]}: &
			${document.serviceDate1.format('dd.MM.yyyy')}
			<#if document.serviceDate2??>
				- ${document.serviceDate2.format('dd.MM.yyyy')}
			</#if>
			\\
        </#if>
        <#if document.referenceNumber != "">
            ${bundle["Document.REFERENCE_NUMBER"]}: & ${document.referenceNumber} \\
        </#if>
    \end{tabular}
}

<#if headless>
    \cfoot*{}
<#else>
    \cfoot*{
        \begin{tabular}[t]{l}
            ${settings["company.name"]} \\
			<#if settings["company.salutation"] != "">
				${bundle["Salutation." + settings["company.salutation"] + ".display"]}
				${settings["company.firstName"]} ${settings["company.lastName"]} \\
			</#if>
            ${settings["company.address1"]} \\
            ${settings["company.address2"]}
			<#if document.country != settings["company.country"]>
            	\\ ${countries[settings["company.country"]]}
			</#if>
        \end{tabular}
        \hfill
        \begin{tabular}[t]{ll}
            <#if settings["company.phone"] != "">
                ${bundle["Setting.company.phone"]}: & ${settings["company.phone"]} \\
            </#if>
            <#if settings["company.fax"] != "">
                ${bundle["Setting.company.fax"]}: & ${settings["company.fax"]} \\
            </#if>
            <#if settings["company.email"] != "">
                ${bundle["Setting.company.email"]}: & ${settings["company.email"]} \\
            </#if>
            <#if settings["company.internet"] != "">
                ${bundle["Setting.company.internet"]}: & ${settings["company.internet"]} \\
            </#if>
        \end{tabular}
        \hfill
        \begin{tabular}[t]{ll}
            <#if settings["company.steuernummer"] != "">
                ${bundle["Setting.company.steuernummer"]}: & ${settings["company.steuernummer"]} \\
            </#if>
            <#if settings["company.vat_number"] != "">
                ${bundle["Setting.company.vat_number"]}: & ${settings["company.vat_number"]} \\
            </#if>
            <#if settings["company.iban"] != "">
                ${bundle["Setting.company.iban"]}: & ${settings["company.iban"]} \\
            </#if>
            <#if settings["company.bic"] != "">
                ${bundle["Setting.company.bic"]}: & ${settings["company.bic"]} \\
            </#if>
        \end{tabular}
    }
</#if>

%\setkomavar{place}{Berlin}
\setkomavar{date}{\today}
\setkomavar{subject}{${subject}}

\begin{document}
\begin{letter}{
    <#if document.company != "">
        ${document.company} \\
        <#if document.salutation??>
            ${bundle["Salutation." + document.salutation + ".display"]}
			${document.prefix} ${document.firstName} ${document.lastName} \\
        </#if>
    <#else>
		${bundle["Salutation." + document.salutation + ".display"]} \\
        ${document.prefix} ${document.firstName} ${document.lastName} \\
    </#if>
    ${document.address1} \\ ${document.address2}
	<#if document.country != settings["company.country"]>
		\\ ${countries[document.country]}
    </#if>
}

<#if document.salutation??>
	<#assign template = texts["Letter.opening." + document.salutation]?interpret>
<#else>
	<#assign template = texts["Letter.opening.company"]?interpret>
</#if>
\opening{<@template />}

<#nested>

<#assign template = texts["Letter.closing"]?interpret>
\closing{<@template />}

\end{letter}
\end{document}
</#macro>
