<#ftl output_format="LaTeX" strict_syntax="true">
<#import "base_letter.tex.ftl" as base_letter>

<#assign subject>${bundle["DocumentType." + document.type]}<#if document.state != "ONGOING"> - ${bundle["OrderState." + document.state]}</#if></#assign>
<@base_letter.base_letter subject=subject>
    <#assign headTemplate = texts["Document." + document.type + ".head"]?interpret>
    <@headTemplate />
    %

    <#assign columnsBeforePrice = 1>
    <#assign complete = true>
	\begin{xltabular}{\textwidth}{X <#if showTaxes>r</#if> r <#if showUnits>l</#if> <#if showPrices>r</#if> <#if showPrices && showDiscount>r</#if> <#if showPrices>r</#if>}
		\multicolumn{1}{l}{\textbf{${bundle["LineItem.ARTICLE_TITLE"]}}}
		<#if showPrices && showTaxes>
			<#assign columnsBeforePrice = columnsBeforePrice + 1>
			& \multicolumn{1}{l}{\textbf{${bundle["LineItem.TAX_RATE_ID"]}}}
		</#if>
		<#if showUnits>
			<#assign columnsBeforePrice = columnsBeforePrice + 2>
			& \multicolumn{2}{l}{\textbf{${bundle["LineItem.AMOUNT"]}}}
		<#else>
			<#assign columnsBeforePrice = columnsBeforePrice + 1>
			& \multicolumn{1}{l}{\textbf{${bundle["LineItem.AMOUNT"]}}}
		</#if>
		<#if showPrices>
			<#assign columnsBeforePrice = columnsBeforePrice + 1>
			& \multicolumn{1}{l}{\textbf{${bundle["LineItem.PRICE.short"]}}}
		</#if>
		<#if showPrices && showDiscount>
			<#assign columnsBeforePrice = columnsBeforePrice + 1>
			& \multicolumn{1}{l}{\textbf{${bundle["LineItem.DISCOUNT"]}}}
		</#if>
		<#if showPrices>
			& \multicolumn{1}{l}{\textbf{${bundle["generic.label.price"]}}}
		</#if>
		\\ \hline
		<#list document.items as item>
			<#if documentUsesVendor>
				<#if item.vendorsArticleNumber != "">
					${item.vendorsArticleNumber} -
				</#if>
			<#else>
				<#if item.articleNumber != "">
					${item.articleNumber} -
				</#if>
			</#if>
			${item.articleTitle}
			<#if item.text != "">
				<#list item.text?split("\n") as line>
					<#if line == "">
						\newline \;
					<#else>
						\newline ${line}
					</#if>
				</#list>
			</#if>
			<#if showPrices && showTaxes>
				<#list taxRates as taxRate>
					<#if taxRate.id == item.taxRateId>
						& ${taxRate.rate?string["0.00"]}\%
					</#if>
				</#list>
			</#if>
			& ${item.amount?string["0.00"]}
			<#if showUnits>
				& ${item.unit}
			</#if>
			<#if showPrices>
				<#if item.price??>
					& ${item.price?string["0.00"]} \euro
				<#else>
					<#assign complete = false>
					& -
				</#if>
			</#if>
			<#if showPrices && showDiscount>
				& ${item.discount?string["0.00"]}\%
			</#if>
			<#if showPrices>
				<#if item.totalPrice??>
					& ${item.totalPrice?string["0.00"]} \euro
				<#else>
					& -
				</#if>
			</#if>
			\\ \hline
		</#list>
		\hline
		<#if showPrices>
			<#if document.deductions?size != 0 || document.partialPrice??>
				\multicolumn{${columnsBeforePrice}}{r}{${bundle["generic.label.netSumBeforeDeductions"]}:} &
					${price.netSumBeforeDeductions?string["0.00"]} \euro \\*
				<#list document.deductions as deduction>
					\multicolumn{${columnsBeforePrice}}{r}{${deduction.title}:} &
						-${deduction.price?string["0.00"]} \euro \\*
				</#list>
				<#if document.partialPrice??>
					\multicolumn{${columnsBeforePrice}}{r}{${bundle["generic.label.netRestDeduction"]}:} &
						-${price.netRestDeduction?string["0.00"]} \euro \\*
				</#if>
				\hline
			</#if>
			<#if document.taxation == "DEFAULT">
				\multicolumn{${columnsBeforePrice}}{r}{${bundle["generic.label.netPrice"]}:} &
					<#if !complete>*</#if> ${price.netSum?string["0.00"]} \euro \\*
				<#list taxRates as taxRate>
					<#if price.taxes?api.containsKey(taxRate.id)>
						\multicolumn{${columnsBeforePrice}}{r}{${taxRate.name} (${taxRate.rate?string["0.00"]}\%):} &
							${price.taxes?api.get(taxRate.id)?string["0.00"]} \euro \\*
					</#if>
				</#list>
				\hline
			</#if>
			\multicolumn{${columnsBeforePrice}}{r}{\textbf{${bundle["generic.label.totalPrice"]}:}} &
				<#if !complete>*</#if> \textbf{${price.totalSum?string["0.00"]} \euro} \\
		</#if>
	\end{xltabular}

    <#if showPrices>
        <#if document.taxation == "KLEINUNTERNEHMER">
            <#assign kluTemplate = texts["Kleinunternehmerregelung"]?interpret>
            <@kluTemplate />
        </#if>
    </#if>
    %

    <#if document.text != "">
        ${document.text}
    </#if>
    %

    <#assign footTemplate = texts["Document." + document.type + ".foot"]?interpret>
    <@footTemplate />
</@base_letter.base_letter>
